import { Link, useParams } from 'react-router-dom'
import React, { useEffect, useState } from 'react';
import RightHamburger from './RightHamburger';
import roomApi from '../../apis/room.api';
import catchErrors from '../../context/catchError';
import userApi from '../../apis/user.api';

const INIT_CHANNEL = {
  channelName: "",
  joinUser: [],
};


const ChannelList = () => {
  const { roomId } = useParams();
  const [error, setError] = useState("");
  const [channel, setChannel] = useState([INIT_CHANNEL]);
  const id = localStorage.getItem('user');

  async function getChannel(roomId) {
    try {
      const data = await roomApi.getRoom([roomId]);
      const Channel = data[0].channel;
      const channelList = [];
      for (const prop in Channel) {
        for (const el in Channel[prop]) {
          channelList.push({
            channelName: el,
            joinUser: Channel[prop][el],
          });
        }
      }
      setChannel(channelList);
    } catch (error) {
      catchErrors(error, setError);
    }
  }

  async function exitChannel() {
    try {
      const data = await userApi.getUser(id);
      const A = doubleJoinCheck(data.name)
      if (A) {
        await roomApi.doubleJoin({ roomId: roomId, index1: A.index1, index2: A.index2, joinChName: A.joinChName })
      }
    } catch (error) {
      catchErrors(error, setError);
    }
  }

  function doubleJoinCheck(e) {
    for (const index in channel) {
      for (const el in channel[index].joinUser) {
        if (channel[index].joinUser[el] === e) {
          const doublejoinCh = channel[index].channelName
          const A = {
            index1: index,
            index2: el,
            joinChName: doublejoinCh,
          }
          return A
        }
      }
    }
  }

  useEffect(() => {
    getChannel(roomId);
  }, [roomId])

  return (
    <div>
      <nav className="navbar navbar-light ">
        <div className="col-2"></div>
        <div onClick={exitChannel}>
          <Link to={`/user/${id}`}>
            <img src="/BORA.png" style={{ width: '160px' }} />
          </Link>
        </div>
        <RightHamburger />
      </nav>
    </div>
  )
}

export default ChannelList
