import bcrypt from "bcryptjs";
import { DataTypes } from "sequelize";

const RoomModel = (sequelize) => {
  const Room = sequelize.define(
    "room",
    {
      id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
      },
      name: {
        type: DataTypes.STRING,
      },
      owner: {
        type: DataTypes.STRING,
      },
      member: {
        type: DataTypes.ARRAY(DataTypes.INTEGER),
      },
      channel: {
        type: DataTypes.ARRAY(DataTypes.JSON),
      },
    },
    { timestamps: true }
  );

  return Room;
};

export default RoomModel;
