import ScreenSelect from './ScreenSelect'
import React, { useState } from 'react';

const Controller = () => {
  const [mic, setMic] = useState(true)
  const [speaker, setSpeaker] = useState(true)
  const [video, setVideo] = useState(true)

  const micOn = (() => setMic(false));
  const micOff = (() => setMic(true));
  const speakerOn = (() => setSpeaker(false));
  const speakerOff = (() => setSpeaker(true));
  const videoOn = (() => setVideo(false));
  const videoOff = (() => setVideo(true));

  return (
    <div className="container">
      <div className="row">
        <div
          className="col d-flex justify-content-center"
          style={{ backgroundColor: '#C4C4C4', position: 'absolute', bottom: 0, width: '414px' }}
        >

          {mic ? <div className="col d-flex justify-content-center">
            <button type="button" className="btn" onClick={micOn}>
              <img src="/micoffbtn.png" width="45" height="40" />
            </button>
          </div>
            : <div className="col d-flex justify-content-center">
              <button type="button" className="btn" onClick={micOff}>
                <img src="/micbtn.png" width="45" height="40" />
              </button>
            </div>
          }
          {speaker ? <div className="col d-flex justify-content-center">
            <button type="button" className="btn" onClick={speakerOn}>
              <img src="/speakeroffbtn.png" width="45" />
            </button>
          </div> : <div className="col d-flex justify-content-center">
            <button type="button" className="btn" onClick={speakerOff}>
              <img src="/speakerbtn.png" width="45" />
            </button>
          </div>
          }
          {video ? <div className="col d-flex justify-content-center">
            <button
              type="button"
              className="btn"
              data-bs-toggle="modal"
              data-bs-target="#shareModal"
              onClick="location.href='ScreenSelect.js'"
              onClick={videoOn}
            >
              <img src="/videooffbtn.png" width="45" />
            </button>
          </div> :
            <div className="col d-flex justify-content-center">
              <button type="button" className="btn" onClick={videoOff}>
                <img src="/videobtn.png" width="45" />
              </button>
            </div>}
        </div>
        <ScreenSelect videoOff={videoOff} />
      </div>


    </div>
  )
}

export default Controller
