import { DataTypes } from "sequelize";

const RoomModel = (sequelize) => {
  const Room = sequelize.define(
    "room",
    {
      id: {
        type: DataTypes.STRING,
        primaryKey: true,
      },
      name: {
        type: DataTypes.STRING,
      },
      owner: {
        type: DataTypes.INTEGER,
      },
      member: {
        type: DataTypes.ARRAY(DataTypes.INTEGER),
        //type: DataTypes.STRING,
      },
      profileimg: {
        type: DataTypes.STRING,
        defaultValue: "/user.png"
      },
      channel: {
        type: DataTypes.ARRAY(DataTypes.JSON),
        defaultValue: [{'회의':""}],
      },
    },
    { timestamps: true }
  );
  return Room;
};

export default RoomModel;

