import { Redirect, Route } from "react-router-dom";
import { useAuth } from "../context/auth_context";
import ErrorPage from "../pages/ErrorPage";
import HomeGuestPage from "../pages/HomeGuestPage";

const PrivateRoute = ({ component: Component, ...rest }) => {
  const { user } = useAuth();
  return (
    <Route
      {...rest}
      render={(props) => {
        if (user) {
          if (rest.role === user.role) {
            return <Component {...props} />;
          } else {
            return <HomeGuestPage />;
          }
        } else {
          return <HomeGuestPage />;
        }
      }}
    />
  );
};

export default PrivateRoute;
