import { DataTypes } from "sequelize";

const RoomModel = (sequelize) => {
  const Room = sequelize.define(
    "room",
    {
      id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
      },
      name: {
        type: DataTypes.STRING,
      },
      owner: {
        type: DataTypes.STRING,
      },
      member: {
        type: DataTypes.ARRAY(DataTypes.INTEGER),
      },
      profileimg: {
        type: DataTypes.STRING,
        default: '3cd14b9bcb2007f324fcb82e0b566cce',
      },
      channel: {
        type: DataTypes.ARRAY(DataTypes.JSON),
      },
    },
    { timestamps: true }
  );

  return Room;
};

export default RoomModel;
