import { useEffect, useState } from "react";
import axios from 'axios'

const INIT_ROOM = {
  roomName: '',
  owner: '123456',
  member: '123456',
  profileimg: [],
}

const AddRoom = () => {
  const [room, setRoom] = useState(INIT_ROOM)
  const [error, setError] = useState("");
  const [success, setSuccess] = useState(false)
  const [disabled, setDisabled] = useState(true)

  useEffect(() => {
    setDisabled(
      !(
        room.name &&
        room.owner &&
        room.member &&
        room.profileimg
      )
    );
  }, [room]);

  //LocalStorage에 user id를 저장할때 id를 owner, member에 저장하기
  //const userId = localStorage.getItem('id')
  // setRoom({...room, [owner]: userId})
  // setRoom({...room, [member]: userId})

  function handleChange(event) {
    const { name, value } = event.target
    setRoom({ ...room, [name]: value })
    console.log(room)
  }

  async function handleSubmit(event) {
    event.preventDefault()
    try {
      console.log('룸룸', room)
      let res = await axios.post("/room/create", room)
      const Id = res.data.id
      alert(`방참여코드는 ${Id}입니다`)
      setSuccess(true)
    } catch (error) {
      // catchErrors(error, setError);
    } finally {
      // setLoading(false);
    }
  }

  if (success) {
    console.log('success', success)
    alert('룸생성이 완료되었습니다!')
    //return <Redirect to='/' />
  }

  const { name, owner, member, profileimg } = room;

  return (
    <div>
      <div className="mx-4 my-3 d-flex justify-content-between">
        <div className="fs-4">
          참여중인 방목록
        </div>
        <button
          type="button"
          className="py-1 px-2"
          data-bs-toggle="modal"
          data-bs-target="#myModal"
          style={{
            display: "flex",
            flexDirection: "column",
            borderStyle: "solid",
            borderRadius: "5px",
            backgroundColor: "#E0CEE8",
            borderColor: "#E0CEE8",
          }}
        >
          추가
        </button>
      </div>

      <div className="modal" id="myModal" tabIndex="-1" aria-hidden="true">
        <div className="modal-dialog">
          <div className="modal-content">
            <div className="modal-header">
              <button
                type="button"
                className="btn-close"
                data-bs-dismiss="modal"
                aria-label="Close"
              ></button>
            </div>
            <div className="modal-body">
              <div className="row justify-content-evenly mt-4 mb-4 fs-6">
                <div className="col-6 d-flex justify-content-center">
                  <button
                    type="button"
                    className="p-3"
                    data-bs-toggle="modal"
                    data-bs-target="#joinModal"
                    style={{
                      display: "flex",
                      flexDirection: "column",
                      borderStyle: "solid",
                      borderRadius: "5px",
                      backgroundColor: "#E0CEE8",
                      borderColor: "#E0CEE8",
                    }}
                  >
                    <div style={{ width: "6rem" }} >
                      방참여하기
                    </div>
                  </button>
                </div>
                <div className="col-6 d-flex justify-content-center">
                  <button
                    type="button"
                    className="p-3"
                    data-bs-toggle="modal"
                    data-bs-target="#makeModal"
                    style={{
                      display: "flex",
                      flexDirection: "column",
                      borderStyle: "solid",
                      borderRadius: "5px",
                      backgroundColor: "#f5cfe3",
                      borderColor: "#f5cfe3",
                    }}
                  >
                    <div style={{ width: "6rem" }} >
                      방생성하기
                    </div>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* 방참여하기 모달 */}
      <div className="form" onSubmit={handleSubmit}>
        <div className="modal" id="joinModal" tabIndex="-1" aria-hidden="true">
          <div className="modal-dialog">
            <div className="modal-content">
              <div className="modal-header">
                <div>방참여하기</div>
                <button
                  type="button"
                  className="btn-close"
                  data-bs-dismiss="modal"
                  aria-label="Close"
                ></button>
              </div>
              <div className="modal-body">
                <div className="input-group mb-3">
                  <input
                    type="text"
                    className="form-control"
                    placeholder="참여코드를 입력하세요"
                    aria-label="참여코드를 입력하세요"
                    aria-describedby="basic-addon1"
                  />
                </div>
                <div className="modal-footer">
                  <button type="submit" className="btn btn-primary">
                    확인
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>


      {/* 방생성하기 모달 */}
      <div className="form" onSubmit={handleSubmit}>
        <div className="modal" id="makeModal" tabIndex="-1" aria-hidden="true">
          <div className="modal-dialog">
            <div className="modal-content">
              <div className="modal-header">
                <div>방생성하기</div>
                <button
                  type="button"
                  className="btn-close"
                  data-bs-dismiss="modal"
                  aria-label="Close"
                ></button>
              </div>
              <div className="modal-body">
                <h6>방프로필사진</h6>
                <div className="mb-4">
                  <input
                    type="file"
                    className="upload-hidden"
                    onChange={handleChange}
                    name="profileimg"
                    value={room.profileimg} />
                </div>
                <h6>방이름</h6>
                <div className="input-group">
                  <input
                    type="text"
                    className="form-control"
                    placeholder="방이름을 입력해주세요"
                    aria-label="방이름 입력해주세요"
                    aria-describedby="basic-addon1"
                    onChange={handleChange}
                    name="name"
                    value={room.name}
                  />
                </div>
                <div className="modal-footer">
                  <button type="submit" className="btn btn-primary">
                    생성
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default AddRoom;
