import { User } from "../models/index.js";
import jwt from "jsonwebtoken";
import config from "../config/app.config.js";
import isLength from 'validator/lib/isLength.js'
import bcrypt from "bcryptjs";

const test = async (req, res) => {
  try {
    console.log(req);
    res.json("안녕");
  } catch (error) {
    console.log(error);
    return res.status(500).send("test 중 에러");
  }
};

const login = async (req, res) => {
  try {
    console.log("login= ", req.body);
    const { email, password } = req.body;
    const user = await User.findOne({ where: { email: email } });
    if (!user)
      return res.status(422).send(`${email} 사용자가 존재하지 않습니다.`);

    const passworMatch = await user.comparePassword(password);
    if (passworMatch) {
      const token = jwt.sign({ userID: user.id }, config.jwtSecret, {
        expiresIn: config.jwtExpires,
      });
      res.cookie(config.cookieName, token, {
        path: "/",
        httpOnly: true,
        secure: true,
      });
      res.json({ user });
    } else {
      res.status(401).send("비밀번호가 일치하지 않습니다.");
    }
  } catch (error) {
    console.log(error);
    return res.status(500).send("로그인 중 에러");
  }
};

const signup = async (req, res) => {
  try {
    console.log('signup= ', req.body);
    const { name, password, id } = req.body; 
    if (!isLength(name, {min: 3, max: 10})) {
      return res.status(422).send('이름은 3-10자 사이입니다')
    } else if (!isLength(password, {min: 6})) {
      return res.status(422).send('비밀번호는 6자 이상입니다')
    } else if (!isLength(id, {min:3, max10})) {
      return res.status(422).send('아이디는 3-10자 사이입니다')
    }
    const user = await User.scope("password").findOne({ where: email });
    if (user)
      return res.status(422).send(`${email} 이미 존재하는 사용자입니다/+ `);

    const hash = await bcrypt.hash(password, 10)
    const newUser = await new User ({
      name,
      password: hash,
      id
    }).save()
    console.log(newUser)
    res.json(newUser)
  } catch (error) {
    console.log(error);
    return res.status(500).send("회원가입 중 에러")
  }
}
export default {
  test,
  login,
  signup,
};
