import backward from '../../backward.png'
import ChannelSingle from './ChannelSingle'

const LeftHamberger = () => {
    function roomIdCopy() {
        const t = document.querySelector('#roomId').innerText;
        console.log(t)
        navigator.clipboard.writeText(t);
        document.execCommand('copy');
    }
    return (
        <div>
            <div>
                <button
                    className="navbar-toggler"
                    type="button"
                    data-bs-toggle="offcanvas"
                    data-bs-target="#left-hamburger"
                    aria-controls="left-hamburger"
                    aria-expanded="false"
                    aria-label="Toggle navigation"
                    style={{ border: '#f4c1f2' }}
                >
                    <span className="navbar-toggler-icon"></span>
                </button>
            </div>


            <div
                className="offcanvas offcanvas-start"
                style={{ width: '330px' }}
                tabIndex="-1"
                id="left-hamburger"
                aria-labelledby="hamburgerLabel"
            >
                <div className="offcanvas-header">
                    <p
                        className="col-6 offcanvas-title"
                        id="offcanvasExampleLabel"
                        style={{
                            fontWeight: 'bold',
                            fontSize: '15px',
                            width: '150px',
                            color: '#000000',
                        }}
                    >
                        온/오프라인 사용자
                    </p>
                    <h6 className="mt-2" id="roomId" > #ASV2AE985 </h6>
                    <button
                        type="button"
                        className="btn-close text-reset"
                        data-bs-dismiss="offcanvas"
                        aria-label="Close"
                    ></button>
                </div>
                <div className="overflow-auto" style={{ height: '610px' }}>
                    <div className="mb-3">
                        <div className="m-3 p-1 row" style={{ backgroundColor: "#E0CEE8" }}>
                            <h5 className="col mt-2">온라인 사용자</h5>
                        </div>
                        <ul className="mx-5" style={{ marker: "#2e873a" }}>
                            <li className="marker: #2e873a" style={{ markerColor: "2px #2e873a" }}>
                                CHERRY
                            </li>
                            <li>
                                JAEYEON
                            </li>
                            <li>
                                SEOYEON
                            </li>
                            <li>
                                JIWEON
                            </li>
                            <li>
                                BYOUNGYUN
                            </li>
                        </ul>
                    </div>

                    <div className="mb-3">
                        <div className="m-3 p-1 row" style={{ backgroundColor: "#E0CEE8" }}>
                            <h5 className="col mt-2">오프라인 사용자</h5>
                        </div>
                        <ul className="mx-5">
                            <li>
                                CHERRY
                            </li>
                            <li>
                                JAEYEON
                            </li>
                            <li>
                                SEOYEON
                            </li>
                            <li>
                                JIWEON
                            </li>
                            <li>
                                BYOUNGYUN
                            </li>
                        </ul>
                    </div>
                </div>

                <div>
                    <div className="d-flex flex-row-reverse">
                        <button
                            type="button"
                            className="m-3 rounded"
                            data-bs-toggle="modal"
                            data-bs-target="#exitRoom"
                            style={{
                                height: '30px',
                                fontWeight: 'bold',
                                backgroundColor: '#E0CEE8',
                                color: 'black',
                                border: '1px #D64D61',
                            }}
                        >
                            초대
                        </button>
                        <div
                            className="modal fade"
                            id="exitRoom"
                            tabIndex="-1"
                            aria-labelledby="exitRoomLabel"
                            aria-hidden="true"
                        >
                            <div className="modal-dialog">
                                <div className="modal-content">
                                    <div className="modal-header">
                                        <button
                                            type="button"
                                            className="btn-close"
                                            data-bs-dismiss="modal"
                                            aria-label="Close"
                                        ></button>
                                    </div>
                                    <div className="modal-body d-flex justify-content-center">
                                        어떤 방식으로 초대하시겠습니까?
                                    </div>
                                    <div className="row mb-3">
                                        <div className="d-flex justify-content-evenly">
                                            <button
                                                type="submit"
                                                className="col-2 p-1 btn btn-primary"
                                                style={{ width: "120px" }}
                                            >
                                                카카오로 초대
                                            </button>
                                            <button
                                                type="submit"
                                                className="col-2 p-1 btn btn-primary"
                                                data-bs-dismiss="modal"
                                                style={{ width: "120px" }}
                                                onClick={roomIdCopy}
                                            >
                                                방 Id 복사
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div >
    )
}

export default LeftHamberger