import { Room, User } from "../models/index.js";
import { customAlphabet } from 'nanoid'
import config from "../config/app.config.js";
import isLength from 'validator/lib/isLength.js'

const nanoid = customAlphabet('1234567890abcdef', 10)

const joinRoom = async (req, res) => {
  console.log('req.body.value:', req.body)
  const { userId, roomId } = req.body
  console.log('userId:', userId)
  console.log('roomId:', roomId)
  const room_Id = await Room.findOne({ where: { id: roomId } });
  console.log('room_Id:', room_Id)
  if (room_Id) {
    //roomId에 일치하는 방의 member정보에 userId 저장하기
    console.log('room_Id.member1:', room_Id.member)
    room_Id.member.push(userId)
    console.log('room_Id.member2:', room_Id.member)
    await Room.update({ 'member': room_Id.member }, { where: { id: roomId } })
    const roomID = await Room.findOne({ where: { id: roomId } });
    console.log('room_Id2:', roomID.member)
    //userId에 일치하는 사용자의 roomNumber에 roomId저장하기
    // const user_Id = await User.findOne({ where: { id: userId } });
    // console.log('user_Id:', user_Id)
    // console.log('user_Id.roomNumber1:', user_Id.roomNumber)
    // user_Id.roomNumber.push(roomId)
    // console.log('user_Id.roomNumber2:', user_Id.roomNumber)
    // await User.update({ 'roomNumber': roomId }, { where: { id: userId } })
    // const userID = await User.findOne({ where: { id: userId } });
    // console.log('user_Id2:', userID.roomNumber)

  } else {
    return res.status(422).send('참여코드와 일치하는 방이 존재하지 않습니다.')
  }
};

// const changemember = async (req, res) => {
//   const { userId, roomId } = req.body
//   // console.log(roomId)
//   let room = await Room.findOne({ roomId: roomId }).select('member')
//   const isPresent = room.member.indexOf(userId)
//   indexOf : userId가 몇번째 인덱스인지 찾기
//   try {
//       if (isPresent < 0) {
//           const memberId = room.member.push(userId)
//           await Room.updateOne({ 'roomId': roomId }, { 'member': room.member })
//           // console.log('room.member 업데이트 완료')
//           return res.json(true)
//       }
//       else {
//           return res.json(false)
//       }
//   } catch (error) {
//       res.status(500).send('멤버 업데이트 실패')
//   }
// }

const createRoom = async (req, res) => {
  console.log('룸정보', req.body)
  const { name, owner, member, profileimg, channel } = req.body;
  console.log('owner:', owner)
  const id = nanoid()
  console.log('id:', id)
  const Id = await Room.findOne({ where: { id: id } });
  console.log("Id중복확인:", Id)
  while (Id) {
    const id = nanoid()
    const Id = await Room.findOne({ where: { id: id } });
  }

  try {
    if (!isLength(name, { min: 3, max: 20 })) {
      console.log('방이름은 3-20자여야 합니다.')
      return res.status(422).send('방이름은 3-20자여야 합니다.')
    }

    const newRoom = await Room.create({
      id: id,
      name: name,
      owner: owner,
      member: member,
      profileimg: profileimg,
      channel: channel,
    }).then(_ => console.log('room정보:', id, name, owner, member, profileimg, channel))
    console.log('newRoom:', newRoom)
    res.json(newRoom)
  } catch (error) {
    console.log(error)
    res.status(500).send('방생성 에러')
  }
}

export default {
  joinRoom, createRoom
};
