import { DataTypes } from "sequelize";

const RoomModel = (sequelize) => {
  const Room = sequelize.define(
    "room",
    {
      id: {
        type: DataTypes.STRING,
        primaryKey: true,
      },
      name: {
        type: DataTypes.STRING,
      },
      owner: {
        type: DataTypes.ARRAY(DataTypes.STRING),
      },
      member: {
        type: DataTypes.ARRAY(DataTypes.STRING),
      },
      profileimg: {
        type: DataTypes.STRING,
      },
      channel: {
        type: DataTypes.ARRAY(DataTypes.JSON),
      },
    },
    { timestamps: true }
  );
  return Room;
};

export default RoomModel;

