import { User } from "../models/index.js";
import config from "../config/app.config.js";

const test = async (req, res) => {
  try {
    console.log(req);
    res.json("안녕");
  } catch (error) {
    console.log(error);
    return res.status(500).send("test 중 에러");
  }
};

const login = async (req, res) => {
  try {
    console.log("login= ", req.body);
    const { email, password } = req.body;
    const user = await User.findOne({ where: { email: email } });
    if (!user)
      return res.status(422).send(`${email} 사용자가 존재하지 않습니다.`);

    const passworMatch = await user.comparePassword(password);
    if (passworMatch) {
      const token = jwt.sign({ userID: user.id }, config.jwtSecret, {
        expiresIn: config.jwtExpires,
      });
      res.cookie(config.cookieName, token, {
        path: "/",
        httpOnly: true,
        secure: true,
      });
      res.json({ user });
    } else {
      res.status(401).send("비밀번호가 일치하지 않습니다.");
    }
  } catch (error) {
    console.log(error);
    return res.status(500).send("로그인 중 에러");
  }
};

const signup = async (req, res) => {
  try {
    console.log("sign up= ", req.body);
  } catch (error) {
    console.log(error);
    return res.status(500).send("회원가입 중 에러");
  }
};

export default {
  test,
  login,
  signup,
};
