import axios from "axios";

const getRoom = async (id) => {
  const { data } = await axios.post('/api/room/getRoom', id);
  return data;
};

const exitRoom = async (ID) => {
  const { data } = await axios.delete(`/api/room/exitRoom/${ID.id}/${ID.roomId}`);
  return data;
};

const create = async (formData) => {
  const { data } = await axios.post("/api/room/create", formData);
  return data;
};

const join = async (payload) => {
  const { data } = await axios.put("/api/room/join", payload);
  return data;
};

const joinChannel = async (payload) => {
  const { data } = await axios.post("/api/room/joinChannel", payload);
  return data;
};

const makeChannel = async (payload) => {
  const { data } = await axios.post("/api/room/makeChannel", payload);
  return data;
};

const roomApi = { getRoom, exitRoom, create, join, joinChannel, makeChannel };

export default roomApi;
