import { BrowserRouter as Router, Route, Switch } from "react-router-dom";
import "./App.css";
import HomeGuestPage from "./pages/HomeGuestPage";
import HomeUserPage from "./pages/HomeUserPage";
import ProfilePage from "./pages/ProfilePage";
import RoomPage from "./pages/RoomPage";
import InfoUpdatePage from "./pages/InfoUpdatePage";
import InvitePage from "./pages/InvitePage";
import SingupPage from "./components/SignUp";
import LoginPage from "./components/Login"

function App() {
  return (
    <Router basename={process.env.PUBLIC_URL}>
      {/* <AuthProvider> */}
      <Switch>
        <Route exact path="/" component={HomeGuestPage} />
        <Route exact path="/user" component={HomeUserPage} />
        <Route exact path="/signup" component={SingupPage} />
        <Route exact path="/login" component={LoginPage} />
        <Route path="/profile/:id/update" component={InfoUpdatePage} />
        <Route path="/profile/:id" component={ProfilePage} />
        <Route path="/room/:roomId/:channelId" component={RoomPage}>
        {/* <Switch>
          <Route path={"/room/:roomId/meeting"}>
            <></>
          </Route>
          <Route path={"/room/:roomId/normal"}>
            <></>
          </Route>
          <Route path={"/room/:roomId/notice"}>
            <></>
          </Route>
        </Switch> */}
        </Route>
        <Route path="/room/Invite" component={InvitePage} />
      </Switch>
      {/* </AuthProvider> */}
    </Router>
  );
}

export default App;
