import { useState, useEffect } from "react";
import { useParams } from "react-router-dom";
import ChannelSingle from "./ChannelSingle";
import Rightimg from "../../images/RightHamburgerImg.png";
import RoomApi from "../../apis/room.api";
import roomApi from "../../apis/room.api";
import catchErrors from "../../context/catchError";

const INIT_CHANNEL = {
    channelName: "",
    joinName: [],
};
const RightHamburger = () => {
    const [channel, setChannel] = useState([INIT_CHANNEL]);
    const { roomId } = useParams();
    const [error, setError] = useState("");

    async function getChannel(roomId) {
        console.log('roomId', roomId)
        const ID = roomId
        try {
            const data = await roomApi.getRoom([ID]);
            const Channel = data[0].channel
            console.log('방데이터:', Channel)
            const channelList = [];
            for (const prop in Channel) { // Channel의 항목(prop)으로 작업을 실행합니다
                for (const key in Channel[prop]) {
                    console.log(key)
                    console.log(prop)
                    console.log(Channel[prop][key])
                    channelList.push({
                        channelName: key,
                        joinName: Channel[prop][key]
                    });
                }
            }
            setChannel(channelList);
        } catch (error) {
            catchErrors(error, setError);
        }
    }
    console.log(channel)

    useEffect(() => {
        console.log('roomId', roomId)
        getChannel(roomId);
    }, [roomId]);
    return (
        <div>
            <div>
                <button
                    className="navbar-toggler"
                    type="button"
                    data-bs-toggle="offcanvas"
                    data-bs-target="#right-hamburger"
                    aria-controls="right-hamburger"
                    aria-expanded="false"
                    aria-label="Toggle navigation"
                    style={{ border: "#f4c1f2" }}
                >
                    <img src={Rightimg} width="50px" height="30px" />
                </button>
            </div>
            <div
                className="offcanvas offcanvas-end"
                style={{ width: "330px" }}
                tabIndex="-1"
                id="right-hamburger"
                aria-labelledby="hamburgerLabel"
            >
                <div className="offcanvas-header">
                    <p
                        className="col-6 offcanvas-title"
                        id="offcanvasExampleLabel"
                        style={{
                            fontWeight: "bold",
                            fontSize: "15px",
                            overflow: "hidden",
                            whiteSpace: "nowrap",
                            width: "150px",
                            color: "#000000",
                        }}
                    >
                        방 이름{/*Room.name*/}
                    </p>
                    <h6 className="mt-2" id="roomId">
                        {" "}
                        {`${roomId}`}{" "}
                    </h6>
                    <button
                        type="button"
                        className="btn-close text-reset"
                        data-bs-dismiss="offcanvas"
                        aria-label="Close"
                    ></button>
                </div>

                <ChannelSingle channel={channel}/>
                <div>
                    <div className="d-flex flex-row-reverse">
                        <button
                            type="button"
                            className="m-3 rounded text-white"
                            data-bs-toggle="modal"
                            data-bs-target="#exitRoom"
                            style={{
                                height: "30px",
                                fontWeight: "bold",
                                backgroundColor: "#d86da6",
                                color: "black",
                                border: "1px #d86da6",
                            }}
                        >
                            퇴장
                        </button>
                        {/* {admin ? (
              <button
                type="button"
                className="m-3 rounded"
                style={{
                  height: "30px",
                  fontWeight: "bold",
                  backgroundColor: "#E0CEE8",
                  color: "black",
                  border: "1px #D64D61",
                }}
              >
                설정
              </button>
            ) : null} */}

                        <div
                            className="modal fade"
                            id="exitRoom"
                            tabIndex="-1"
                            aria-labelledby="exitRoomLabel"
                            aria-hidden="true"
                        >
                            <div className="modal-dialog">
                                <div className="modal-content">
                                    <div className="modal-header">
                                        <button
                                            type="button"
                                            className="btn-close"
                                            data-bs-dismiss="modal"
                                            aria-label="Close"
                                        ></button>
                                    </div>
                                    <div className="modal-body d-flex justify-content-center">
                                        이방에서 퇴장하시겠습니까?
                                    </div>
                                    <div className="row mb-3">
                                        <div className="d-flex justify-content-evenly">
                                            {/* <Link to="/user/:id"> */}
                                            <button
                                                type="submit"
                                                className="col-2 p-1 btn btn-primary"
                                                data-bs-dismiss="modal"
                                            >
                                                예
                                            </button>
                                            {/* </Link> */}
                                            <button
                                                type="submit"
                                                className="col-2 p-1 btn btn-primary"
                                                data-bs-dismiss="modal"
                                            >
                                                아니요
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
};

export default RightHamburger;