import { useEffect, useState } from "react";
const INIT_USER = {
  id: "",
  password: "",
};

const Login = () => {
  //   const { error, loading, login } = useAuth();
  const [user, setUser] = useState(INIT_USER);
  const [disabled, setDisabled] = useState(true);
  const [error, setError] = useState("");
  const [success, setSuccess] = useState(false);

  useEffect(() => {
    const isUser = Object.values(user).every((el) => Boolean(el));
    isUser ? setDisabled(false) : setDisabled(true);
  }, [user]);

  function handleChange(event) {
    const { name, value } = event.target;
    setUser({ ...user, [name]: value });
    console.log(user);
  }

  async function handleSubmit() {
    try {
      // setLoading(true);
      // setError("");
      //   const success = await login(user.email, user.password);
      console.log(user);
      setSuccess(success);
    } catch (error) {
      // catchErrors(error, setError);
    } finally {
      // setLoading(false);
    }
  }

  const { id, password } = user;

  return (
    <div className="modal-content">
      <form onSubmit={handleSubmit}>
        <div className="modal-header">
          <h5 className="modal-title" id="loginModalLabel">
            로그인
          </h5>
          <button
            type="button"
            className="btn-close"
            data-bs-dismiss="modal"
            aria-label="Close"
          ></button>
        </div>
        <div className="modal-body">
          <div>
            <label>아이디</label>
            <input
              className="form-control"
              id="id"
              type="text"
              name="id"
              placeholder="아이디를 입력하세요"
              value={id}
              onChange={handleChange}
            />
          </div>
          <div>
            <label>비밀번호</label>
            <input
              className="form-control"
              id="password"
              type="password"
              name="password"
              placeholder="비밀번호를 입력하세요"
              value={password}
              onChange={handleChange}
            />
          </div>
        </div>
        <div className="modal-footer">
          <button type="submit" className="btn btn-primary" disabled={disabled}>
            로그인
          </button>
        </div>
      </form>
    </div>
  );
};

export default Login;
