import { Link, useParams } from "react-router-dom";
import React, { useEffect, useState } from "react";
import userApi from "../../apis/user.api";

const userprofile = localStorage.getItem("user");
const INIT_PROFILE = {
  id: userprofile,
  name:"",
  email:"",
  phone:"",
  img: "",
};

const InfoUpdate = () => {
  const { id } = useParams();


  const [profile, setProfile] = useState(INIT_PROFILE);

  async function getProfile(userID) {
    try {
      const data = await userApi.getUser(userID);
      setProfile(data);
    } catch (error) {}
  }

  useEffect(() => {
    getProfile(userprofile);
  }, []);

  const handleChange = async (event) => {
    const { files } = event.target;
    let formData = new FormData();
    formData.append("img", files[0]);
    formData.append("id", userprofile);
    try {
      const res = await userApi.profileimg(formData);
      if(files){
        setProfile({...profile, img:res})
      }else{
        setProfile()
      }   } catch (error) {}
  };

  const changeinfo = async (event) => {
    const res = await userApi.updateinfo(profile)
  };
  const updateinfo = (event) => {
    const { name, value } = event.target;
    setProfile({ ...profile, [name]: value });
  };

  const{email,phone,name}=profile
  return (
    <div className="container" style={{ background: "#FCF4FF" }}>
      <div className="row">
        <div>
          <label
            className="form-label mx-2 my-4"
            style={{ fontSize: "18px", fontWeight: "bold" }}
          >
            프로필 정보
          </label>
          <Link to={`/profile/${id}`}>
            <button
              type="button"
              className="btn btn-outline-white "
              style={{
                background: "#d4cafb",
                fontSize: "13px",
                fontWeight: "bold",
              }}
            >
              돌아가기
            </button>
          </Link>
          <Link to={`/profile/${id}`}>
            <button
              onClick={changeinfo}
              type="button"
              className="btn btn-outline-white mx-2 "
              style={{
                background: "#d4cafb",
                fontSize: "13px",
                fontWeight: "bold",
              }}
            >
              저장
            </button>
          </Link>
        </div>
      </div>

      <div className="col">
        <div>
          <div className="row">
            <div
              className="d-flex justify-content-center"
              style={{ position: "relative" }}
            >
              <img
                src={`/uploads/${profile.img}`}
                alt="profileImg"
                id="imgfile"
                className="rounded-circle mt-2"
                style={{ height: "320px", width: "320px" }}
              />
              <div
                className="d-flex justify-content-end"
                style={{ position: "absolute", left: "295px", top: "30px" }}
              >
                <label htmlFor="inputfile">
                  <img
                    className="rounded-circle"
                    alt="newProfileImg"
                    src="/infoimg.jpg"
                    style={{
                      width: "50px",
                      height: "50px",
                      backgroundColor: "white",
                    }}
                  />
                </label>
                <input
                  onChange={handleChange}
                  name="avatarUrl"
                  type="file"
                  accept="image/*"
                  id="inputfile"
                  style={{ display: "none" }}
                />
              </div>
            </div>

            <div className="col d-flex justify-content-center">
              <input
                onChange={updateinfo}
                name="email"
                value={profile.email}
                type="text"
                className="form-control my-4 "
                placeholder="사용자명 입력"
                style={{
                  background: "#fcf4ff",
                  borderTop: "0",
                  borderRight: "0",
                  borderLeft: "0",
                  borderBottom: "1",
                  borderColor: "#d4cafb",
                  height: "38px",
                  width: "130px",
                }}
              />
              <div
                className="justify-content-center ms-2 my-4"
                style={{ fontSize: "25px", fontWeight: "bold" }}
              >
                #{userprofile}
              </div>
            </div>
            <div className="row">
              <div className="col-3"></div>
              <div className="col-6 my-2">
                <h2
                  className="mb-3"
                  style={{ fontSize: "13px", fontWeight: "bold" }}
                >
                  이름
                </h2>
                <input
                  onChange={updateinfo}
                  name="name"
                  value={profile.name}
                  type="text"
                  className="form-control my-3 "
                  placeholder="이름 입력"
                  style={{
                    background: "#fcf4ff",
                    borderTop: "0",
                    borderRight: "0",
                    borderLeft: "0",
                    borderBottom: "1",
                    borderColor: "#d4cafb",
                    height: "38px",
                    width: "180px",
                  }}
                />

                <h2
                  className="mb-3 mt-2"
                  style={{ fontSize: "13px", fontWeight: "bold" }}
                >
                  전화번호
                </h2>
                <input
                  onChange={updateinfo}
                  name="phone"
                  value={profile.phone}
                  type="text"
                  className="form-control my-3 "
                  placeholder="전화번호 입력"
                  style={{
                    background: "#fcf4ff",
                    borderTop: "0",
                    borderRight: "0",
                    borderLeft: "0",
                    borderBottom: "1",
                    borderColor: "#d4cafb",
                    height: "38px",
                    width: "180px",
                  }}
                />
              </div>
              <div className="col"></div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default InfoUpdate;
