import Header from "../components/Header";
import ChannelList from "../components/Room/ChannelList";
import RoomHeader from "../components/Room/RoomHeader";
import Screen from "../components/Room/Screen";
import User from "../components/Room/User";
import Controller from "../components/Room/Controller";
import { useState } from "react";

const RoomPage = () => {
  const [mic, setMic] = useState(true);
  const [speaker, setSpeaker] = useState(true);
  const [video, setVideo] = useState(true);

  const micClick = () => setMic(!mic);
  const speakerClick = () => setSpeaker(!speaker);
  const videoClick = () => setVideo(!video);
  return (
    <div>
      {/* <Header hamburger={ChannelList} /> */}
      <ChannelList />
      <RoomHeader />
      <Screen mic={mic} video={video} />
      <User />
      <Controller
        mic={mic}
        speaker={speaker}
        video={video}
        micClick={micClick}
        speakerClick={speakerClick}
        videoClick={videoClick}
      />
    </div>
  );
};

export default RoomPage;
