const AddRoom = () => {
  return (
    <form className="m-3">
      <div className="row justify-content-around">
        <div className="col">
          <h4>참여중인 방목록</h4>
        </div>
        <button
          type="button"
          className="col-2"
          data-bs-toggle="modal"
          data-bs-target="#myModal"
          style={{ backgroundColor: "#FCF4FF", borderColor: "#FCF4FF" }}
        >
          +
        </button>
      </div>

      <div className="modal" id="myModal" tabIndex="-1" aria-hidden="true">
        <div className="modal-dialog">
          <div className="modal-content">
            <div className="modal-header">
              <button
                type="button"
                className="btn-close"
                data-bs-dismiss="modal"
                aria-label="Close"
              ></button>
            </div>
            <div className="modal-body">
              <div className="row justify-content-around mt-4 mb-4">
                <div className="col-5">
                  <button
                    type="button"
                    className="p-4"
                    data-bs-toggle="modal"
                    data-bs-target="#joinModal"
                    style={{
                      display: "flex",
                      flexDirection: "column",
                      borderStyle: "solid",
                      borderRadius: "5px",
                      borderColor: "#C4C4C4",
                      backgroundColor: "#C4C4C4",
                      padding: "10px",
                    }}
                  >
                    방참여하기
                  </button>
                </div>
                <div className="col-5">
                  <button
                    type="button"
                    className="p-4"
                    data-bs-toggle="modal"
                    data-bs-target="#makeModal"
                    style={{
                      display: "flex",
                      flexDirection: "column",
                      borderStyle: "solid",
                      borderRadius: "5px",
                      borderColor: "#C4C4C4",
                      backgroundColor: "#C4C4C4",
                      padding: "10px",
                    }}
                  >
                    방생성하기
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* 방참여하기 모달 */}
      <div className="modal" id="joinModal" tabIndex="-1" aria-hidden="true">
        <div className="modal-dialog">
          <div className="modal-content">
            <div className="modal-header">
              <div>방참여하기</div>
              <button
                type="button"
                className="btn-close"
                data-bs-dismiss="modal"
                aria-label="Close"
              ></button>
            </div>
            <div className="modal-body">
              <div className="input-group mb-3">
                <input
                  type="text"
                  className="form-control"
                  placeholder="참여코드를 입력하세요"
                  aria-label="참여코드를 입력하세요"
                  aria-describedby="basic-addon1"
                />
              </div>
              <div className="modal-footer">
                <button
                  type="button"
                  className="btn-primary"
                  style={{
                    borderStyle: "solid",
                    borderRadius: "5px",
                    padding: "15px",
                  }}
                >
                  확인
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* 방생성하기 모달 */}
      <div className="modal" id="makeModal" tabIndex="-1" aria-hidden="true">
        <div className="modal-dialog">
          <div className="modal-content">
            <div className="modal-header">
              <div>방생성하기</div>
              <button
                type="button"
                className="btn-close"
                data-bs-dismiss="modal"
                aria-label="Close"
              ></button>
            </div>
            <div className="modal-body">
              <h5>방프로필사진</h5>
              <div className="filebox mb-4">
                <input type="file" id="ex_filename" className="upload-hidden" />
              </div>
              <h5>방이름</h5>
              <div className="input-group">
                <input
                  type="text"
                  className="form-control"
                  placeholder="방이름을 입력해주세요"
                  aria-label="방이름 입력해주세요"
                  aria-describedby="basic-addon1"
                />
              </div>
              <div className="modal-footer">
                <button
                  type="button"
                  className="btn-primary"
                  style={{
                    borderStyle: "solid",
                    borderRadius: "5px",
                    padding: "15px",
                  }}
                >
                  생성
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </form>
  );
};

export default AddRoom;
