import ChannelSingle from "./ChannelSingle";
import { Link } from "react-router-dom";

const ChannelList = () => {
  return (
    <div>
      <nav className="row navbar navbar-light">
        <div className="col-4">
          <Link to="/user">
            <button
              type="button"
              className="m-2 rounded"
              style={{
                height: "30px",
                fontWeight: "bold",
                backgroundColor: "#E8B7FF",
                color: "black",
                border: "1px #f4c1f2",
              }}
            >
              돌아가기
            </button>
          </Link>
        </div>

        <div className="col-4 d-flex justify-content-center">
          <Link to="/user">
            <img src="/BORA.png" style={{ width: "160px" }} />
          </Link>
        </div>

        <div className="col-4 d-flex justify-content-end">
          <button
            className="navbar-toggler"
            type="button"
            data-bs-toggle="offcanvas"
            data-bs-target="#hamburger"
            aria-controls="hamburger"
            aria-expanded="false"
            aria-label="Toggle navigation"
            style={{ border: "#f4c1f2", }}
          >
            <span className="navbar-toggler-icon"></span>
          </button>
        </div>
      </nav>

      <div className="offcanvas offcanvas-start" tabindex="-1" id="hamburger" aria-labelledby="hamburgerLabel">
        <div className="offcanvas-header">
          <h5 className="offcanvas-title" id="offcanvasExampleLabel">음성 채널 목록</h5>
          <button type="button" className="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>

        <div className="overflow-auto" style={{ height: "610px" }}>
          <div className="mb-3">
            <div className="m-3 p-2 row" style={{ backgroundColor: "#C4C4C4" }}>
              <img className="col-auto" src="/fullSpeaker.png" width="30px" height="30px" />
              <h5 className="col">회의</h5>
            </div>
            <div className="mx-5">
              <ChannelSingle />
            </div>
          </div>
          <div className="mb-3">
            <div className="m-3 p-2" style={{ backgroundColor: "#C4C4C4" }}>
              <h5>사담</h5>
            </div>
            <div className="mx-5">
              <ChannelSingle />
            </div>
          </div>
          <div className="mb-3">
            <div className="m-3 p-2" style={{ backgroundColor: "#C4C4C4" }}>
              <h5>공지</h5>
            </div>
            <div className="mx-5">
              <ChannelSingle />
            </div>
          </div>
          <div className="mb-3">
            <div className="m-3 p-2" style={{ backgroundColor: "#C4C4C4" }}>
              <h5>공지</h5>
            </div>
            <div className="mx-5">
              <ChannelSingle />
            </div>
          </div>
        </div>

        <div className="d-flex flex-row-reverse">
          <button
            type="button"
            className="m-3 rounded text-white"
            data-bs-toggle="modal"
            data-bs-target="#exitRoom"
            style={{
              height: "30px",
              fontWeight: "bold",
              backgroundColor: "#FF0000",
              color: "black",
              border: "1px #f4c1f2",
            }}
          >
            퇴장
          </button>
          <div className="modal fade" id="exitRoom" tabindex="-1" aria-labelledby="exitRoomLabel" aria-hidden="true">
            <div className="modal-dialog">
              <div className="modal-content">
                <div className="modal-header">
                  <button type="button" className="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div className="modal-body d-flex justify-content-center">
                  이방에서 퇴장하시겠습니까?
                </div>
                <div className="row mb-3">
                  <div className="d-flex justify-content-evenly">
                    {/* <Link to="/user"> */}
                    <button type="submit" className="col-2 p-1 btn btn-primary">예</button>
                    {/* </Link> */}
                    <button type="submit" className="col-2 p-1 btn btn-primary" data-bs-dismiss="modal">아니요</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>


    </div >
  );
};

export default ChannelList;
