import { Room, User } from "../models/index.js";
import { customAlphabet } from 'nanoid'
import config from "../config/app.config.js";
import isLength from 'validator/lib/isLength.js'

const nanoid = customAlphabet('1234567890abcdef', 10)

const joinRoom = async (req, res) => {
  console.log('req.body.value:', req.body)
  const { userId, roomId } = req.body
  const room_Id = await Room.findOne({ where: { id: roomId } });
  console.log('room_Id1:', room_Id)
  console.log('room_Id있는지:', Boolean(room_Id))
  if (Boolean(room_Id)) {
    //roomId에 일치하는 방의 member정보에 userId 저장하기
    const userInter = await Room.findOne({
      where: { id: roomId },
      Include: { member: userId }
    }).then(_ => console.log('userInter되었습니다!'));
    //const userInter = await Room.findOne({ Include: [{ id: roomId}, {member: userId}] });
    console.log('userInter:',userInter)
    console.log('userId:',userId)
    if (Boolean(userInter)) {
      return res.status(422).send('이미 참여된 방입니다.')
    }
    else {
      room_Id.member.push(userId)
      console.log('room_Id.member2:', room_Id.member)
      await Room.update({ 'member': room_Id.member }, { where: { id: roomId } })
      const roomID = await Room.findOne({ where: { id: roomId } });
      console.log('room_Id2:', roomID.member)
      // }
      //userId에 일치하는 사용자의 roomNumber에 roomId저장하기
      const user_Id = await User.findOne({ where: { id: userId } });
      console.log('user_Id:', user_Id)
      console.log('user_Id.roomNumber1:', user_Id.roomNumber)
      if (user_Id.roomNumber) {
        user_Id.roomNumber.push(roomId)
      }
      else {
        user_Id.roomNumber = roomId
      }
      console.log('user_Id.roomNumber2:', [user_Id.roomNumber])
      await User.update({ 'roomNumber': [user_Id.roomNumber] }, { where: { id: userId } })
      // .then(_ => res.json(true))
      // const userID = await User.findOne({ where: { id: userId } });
      // console.log('user_Id2:', userID.roomNumber)
    }
  } else {
    return res.status(422).send('참여코드와 일치하는 방이 존재하지 않습니다.')
  }
};

const createRoom = async (req, res) => {
  console.log('룸정보', req.body)
  const { name, owner, member, profileimg } = req.body;
  const id = nanoid()
  const Id = await Room.findOne({ where: { id: id } });
  console.log('id:', id)
  while (Boolean(Id)) {
    const id = nanoid()
    const Id = await Room.findOne({ where: { id: id } });
  }
  try {
    if (!isLength(name, { min: 3, max: 20 })) {
      console.log('방이름은 3-20자여야 합니다.')
      return res.status(422).send('방이름은 3-20자여야 합니다.')
    }
    const newRoom = {
      id: id,
      name: name,
      owner: owner,
      member: [member],
      profileimg: profileimg,
    }
    console.log('newRoom:', newRoom)
    await Room.create(newRoom).then(_ => console.log('room정보:', id, name, owner, [member], profileimg))
    res.json(newRoom)
  } catch (error) {
    console.log(error)
    res.status(500).send('방생성 에러')
  }
}

export default {
  joinRoom, createRoom
};
