import { DataTypes } from "sequelize";

const RoomModel = (sequelize) => {
  const Room = sequelize.define(
    "room",
    {
      id: {
        type: DataTypes.STRING,
        primaryKey: true,
      },
      name: {
        type: DataTypes.STRING,
      },
      owner: {
        type: DataTypes.INTEGER,
      },
      member: {
        type: DataTypes.ARRAY(DataTypes.STRING),
        //type: DataTypes.STRING,
      },
      profileimg: {
        type: DataTypes.STRING,
        defaultValue: "defaultimg"
      },
      channel: {
        type: DataTypes.ARRAY(DataTypes.JSON),
        defaultValue: [{"회의": ["지원", "재연"]}, {"사담": ["지원", "재연", "서연"]}],
      },
    },
    { timestamps: true }
  );
  return Room;
};

export default RoomModel;

