import { useEffect, useState } from "react";
import { useParams } from "react-router";
import roomApi from '../../apis/room.api';
import catchErrors from '../../context/catchError';

const INIT_ROOM = {
  profileimg: "",
};


const RoomHeader = () => {
  const {roomId}=useParams();
  const [room, setRoom] = useState([INIT_ROOM]);
  const [error, setError] = useState("")
  async function getRoom(Id) {
    try {
      const Room = await roomApi.getRoom([Id]);
        setRoom({profileimg: Room[0].profileimg})
        console.log(room)
      }
     catch (error) {
      catchErrors(error, setError);
    }
  }

  useEffect(() => {
    getRoom(roomId);
  }, [roomId]);

  return (
    <div
      className="d-flex justify-content-between align-items-center p-2"
      style={{ backgroundColor: '#C4C4C4', height: '60px' }}
    >
      <div className="d-flex align-items-center">
        <img
          className="rounded-circle"
          src={`/roomUploads/${room.profileimg}`}
          width="40px"
          height="40px"
        />
        <a
          className="p-3 ms-1 text-center text-decoration-none"
          style={{
            fontWeight: 'bold',
            fontSize: '20px',
            color: '#6c33a2',
          }}
        >
          # 회의
        </a>
      </div>
    </div>
  )
}

export default RoomHeader
