import { useEffect, useState } from "react";
import catchErrors from "../../context/catchError";
import { useParams } from "react-router-dom";
import roomApi from "../../apis/room.api";

const INIT_ROOM = {
    id: "",
    name: "",
    profileimg: "",
};

const InitRoom = () => {
    const { roomId } = useParams();
    const [room, setRoom] = useState(INIT_ROOM);
    const [error, setError] = useState("");

    async function getRoom(roomId) {
        console.log(roomId)
        try {
            const data = await roomApi.getRoom([roomId]);
            setRoom(data[0]);
        } catch (error) {
            catchErrors(error, setError);
        }
    }
    console.log(room)

    useEffect(() => {
        console.log('roomId확인', roomId)
        getRoom(roomId);
    }, [roomId]);

    return (
        <div>
            <div style={{ backgroundColor: "#262626", width: "auto", height: "2px" }} />
            <form className="flex-row align-items-center justify-content-center m-5">
                <div className="d-flex justify-content-center">
                    <img
                        src={`/roomUploads/${room.profileimg}`}
                        className="rounded-circle"
                        style={{
                            width: "250px",
                            height: "250px",
                        }}
                    />
                </div>
                <div className="d-flex justify-content-center mt-3">
                    <div>
                        <div className="row">
                            <h6 className="col" style={{ text: 'center' }}> 방이름 </h6>
                            <h4 className="col"> {room.name} </h4>
                        </div>
                        <div className="row">
                            <h6 className="col"> 방코드 </h6>
                            <h4 className="col"> {room.id} </h4>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    );
};

export default InitRoom;
