import { Link } from "react-router-dom";
import { useState, useEffect } from "react";
import userApi from "../../apis/user.api";
import catchErrors from "../../context/catchError";

const userprofile = sessionStorage.getItem("user");
const INIT_USER = {
  id: userprofile,
  email: "",
  img: "",
};

const HomeProfile = () => {
  const [user, setUser] = useState(INIT_USER);
  const [error, setError]= useState("");
  
  async function getSetUser(userID) {
    try {
      const data = await userApi.getUser(userID);

      setUser(data);
    } catch (error) {
      catchErrors(error, setError);
    }
  }

  useEffect(() => {
    getSetUser(userprofile);
  }, [userprofile]);

  return (
    <Link to={`/profile/${user.id}`} className="text-decoration-none text-dark">
      <form className="flex-column align-items-center justify-content-center m-2">
        <div className="d-flex justify-content-center">
          <img
            src={`/uploads/${user.img}`}
            className="rounded-circle"
            style={{
              width: "157px",
              height: "157px",
            }}
          />
        </div>
        <h1 className="d-flex justify-content-center"> {user.email} </h1>
        <h2 className="d-flex justify-content-center"> #{user.id} </h2>
      </form>
      <div
        style={{ backgroundColor: "#262626", width: "auto", height: "2px" }}
      />
    </Link>
  );
};

export default HomeProfile;
