import { useParams } from "react-router-dom";
import React, { useEffect, useState } from "react";
import RoomApi from "../../apis/room.api";
import catchErrors from "../../context/catchError";

const INIT_Room = {
  id: "",
  name: "",
};

const Roomnamechange = () => {
  const { roomId } = useParams();
  const [Room, setRoom] = useState(INIT_Room);
  const [error, setError] = useState("");

  Room.id = roomId;

  async function getdata(Roomdata) {
    try {
      const data = await RoomApi.getRoom([Roomdata]);
      setRoom(data);
      console.log(data);
    } catch (error) {
      catchErrors(error, setError);
    }
  }
  useEffect(() => {
    getdata(roomId);
  }, []);

  const updateinfo = (event) => {
    const { name, value } = event.target;
    setRoom({ ...Room, [name]: value });
    console.log(Room);
  };

  const changeinfo = async (event) => {
    const req = await RoomApi.changename(Room);
  };

  return (
    <div className="d-flex flex-row-reverse">
      <button
        type="submit"
        data-bs-toggle="modal"
        data-bs-target="#changeRoomname"
        style={{
          weight: "100px",
          height: "60px",
          backgroundColor: "#f5cfe3",
          borderRadius: "5px",
          color: "black",
          border: "1px #f5cfe3",
        }}
      >
        방 이름 변경
      </button>

      <div
        className="modal fade"
        id="changeRoomname"
        tabIndex="-1"
        aria-labelledby="changeRoomnameLabel"
        aria-hidden="true"
      >
        <div className="modal-dialog">
          <div className="modal-content">
            <div className="modal-header">
              <button
                type="button"
                className="btn-close"
                data-bs-dismiss="modal"
                aria-label="Close"
              ></button>
            </div>
            <div className="modal-body d-flex justify-content-center"></div>
            <div className="row mb-3">
              <div className="d-flex justify-content-center" style={{ margin:"0px"}}>
                {/* <Link to="/user/:id"> */}
                <p style={{marginTop: "31px", marginBottom: "0px"}}>방 이름: </p>
                <input
                  onChange={updateinfo}
                  name="name"
                  value={Room.name}
                  type="text"
                  className="form-control my-4 "
                  placeholder="변경할 방 이름 입력"
                  style={{
                    background: "#fcf4ff",
                    borderTop: "0",
                    borderRight: "0",
                    borderLeft: "0",
                    borderBottom: "1",
                    borderColor: "#d4cafb",
                    height: "38px",
                    width: "130px",
                    marginTop: "0px",
                    marginBottom: "0px"
                  }}
                />
                </div>
                <div className="d-flex justify-content-evenly">
                {/* <Link to={`/room/${roomId}/${Room.channel}`}> */}
                <button
                  onClick={changeinfo}
                  type="button"
                  className="col-2 p-1 btn btn-primary"
                >
                  저장
                </button>
                {/* </Link> */}
                <button
                  type="submit"
                  className="col-2 p-1 btn btn-primary"
                  data-bs-dismiss="modal"
                >
                  취소
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Roomnamechange;
