import { Link, Route, Switch, useParams } from "react-router-dom";

const ChannelSingle = (props) => {
  const { roomId } = useParams();
  console.log("props", props.channel);
  return (
    <div>
      <div className="overflow-auto" style={{ height: "610px" }}>
        {props.channel.map((el) => (
          <div className="mb-3">
            <Link to={`/room/${roomId}/${el.channelName}`}>
              <div
                className="m-3 p-1 row"
                style={{ backgroundColor: "#E0CEE8" }}
              >
                <img
                  className="col-auto mt-2"
                  src="/fullSpeaker.png"
                  width="25px"
                  height="25px"
                />
                <h5 className="col mt-2" style={{ color: "black" }}>
                  {el.channelName}
                </h5>
              </div>{" "}
            </Link>

            {el.joinName &&
              el.joinName.map((e) => (
                <div>
                  <ul className="mx-5" style={{ color: "#76D079" }}>
                    <li>
                      <p style={{ color: "black" }}>{e}</p>
                    </li>
                  </ul>
                </div>
              ))}
          </div>
        ))}
      </div>
    </div>
  );
};

export default ChannelSingle;
