import { Room, User } from "../models/index.js";
import { customAlphabet } from "nanoid";
import isLength from "validator/lib/isLength.js";
import RoomModel from "../models/room.model.js";
import multer from "multer";
const nanoid = customAlphabet("1234567890abcdef", 10);

const joinRoom = async (req, res) => {
  const { userId, roomId } = req.body;
  const room_Id = await Room.findOne({ where: { id: roomId } });
  if (Boolean(room_Id)) {
    //roomId에 일치하는 방이 존재할때
    //roomId에 일치하는 방의 member정보에 userId 저장하기
    //member정보에 userId가 이미 저장되어 있는지 확인 -> 이미 참여된 방인지 확인
    const includeUserId = room_Id.member.includes(userId);
    if (!includeUserId) {
      //아직 참여되지 않은 방인경우
      room_Id.member.push(userId); //member에 userId추가
      await Room.update({ member: room_Id.member }, { where: { id: roomId } });
      //userId에 일치하는 사용자의 roomNumber에 roomId저장하기
      const user_Id = await User.findOne({ where: { id: userId } });
      if (Boolean(user_Id.roomNumber)) {
        //다른 roomNumber가 이미 들어가 있는 경우 roomId추가
        user_Id.roomNumber.push(roomId);
      } else {
        //첫 roomNumber인 경우
        user_Id.roomNumber = [roomId];
      }
      await User.update(
        { roomNumber: user_Id.roomNumber },
        { where: { id: userId } }
      );
      res.json(true);
    } else {
      return res.status(422).send("이미 참여된 방입니다.");
    }
  } else {
    return res.status(422).send("참여코드와 일치하는 방이 존재하지 않습니다.");
  }
};

const upLoadRoomImg = multer({ dest: "roomUploads/" });
const roomImgUpload = upLoadRoomImg.fields([
  { name: "profileimg", maxCount: 1 },
]);

const update = async (req, res) => {
  try {
    console.log("id:", req.body.id);
    const id = req.body.id; //roomId
    const avatar = req.files["profileimg"][0]; //profileimg
    const img = avatar.filename;
    console.log(img);
    await Room.update({ profileimg: img }, { where: { id: id } });
    res.json(img);
  } catch (error) {
    console.log(error);
    res.status(500).send("이미지 업데이트 실패");
  }
};

const createRoom = async (req, res) => {
  const { userId, name } = req.body;
  const avatar = req.files["profileimg"][0];
  const img = avatar.filename;
  const id = nanoid();
  const Id = await Room.findOne({ where: { id: id } });
  while (Id) {
    const id = nanoid();
    const Id = await Room.findOne({ where: { id: id } });
  }
  try {
    if (!isLength(name, { min: 3, max: 20 })) {
      return res.status(422).send("방이름은 3-20자여야 합니다.");
    }
    //새로운 RoomDB생성
    const newRoom = {
      id: id,
      name: name,
      owner: userId,
      member: [userId],
      profileimg: img,
    };
    await Room.create(newRoom);

    //user.roomNumber에 id추가
    const user_Id = await User.findOne({ where: { id: userId } });
    if (user_Id.roomNumber) {
      //다른 roomNumber가 이미 들어가 있는 경우 id추가
      user_Id.roomNumber.push(id);
    } else {
      //첫 roomNumber인 경우
      user_Id.roomNumber = [id];
    }
    await User.update(
      { roomNumber: user_Id.roomNumber },
      { where: { id: userId } }
    );
    res.json(newRoom);
  } catch (error) {
    console.log(error);
    res.status(500).send("방생성 에러");
  }
};

const getRoom = async (req, res) => {
  try {
    const roomlist = await Room.findAll({ where: { id: req.body } });
    res.json(roomlist);
  } catch (error) {
    res.status(500).send("에러");
  }
};

const exitRoom = async (req, res) => {
  const { id, roomId } = req.params;
  try {
    const room = await Room.findOne({ where: { id: roomId } });
    const index = room.member.indexOf(id);
    room.member.splice(index, 1);
    const newRoom = await Room.update(
      { member: room.member },
      { where: { id: roomId } }
    );

    const user = await User.findOne({ where: { id: id } });
    console.log('user',user, user.roomNumber)
    const index2 = user.roomNumber.indexOf(roomId);
    console.log('제발제발',index2, roomId, user.roomNumber)
    user.roomNumber.splice(index2, 1);
    const newUser = await User.update(
      { roomNumber: user.roomNumber },
      { where: { id: id } }
    );
    return res.json(room);
  } catch (error) {
    res.status(500).send("에러");
  }
};

const changename = async (req, res) => {
  const { id, name } = req.body;
  try {
    await Room.update({ name: name }, { where: { id: id } });
    const room1 = await Room.findOne({ where: { id: id } });
    return res.body.json(true)
  } catch (error) {
    res.status(500).send("에러");
  }
};

const joinChannel = async (req, res) => {
  const { roomId, channelName, plusUser, index } = req.body;
  try {
    const room = await Room.findOne({ where: { id: roomId } });
    room.channel[index][channelName].push(plusUser);
    await Room.update({ channel: room.channel }, { where: { id: roomId } });
    return res.json(true)
  } catch (error) {
    res.status(500).send("error");
  }
};

const doubleJoin = async (req, res) => {
  const { roomId, index1, index2, joinChName } = req.body;
  try {
    const room = await Room.findOne({ where: { id: roomId } });
    room.channel[index1][joinChName].splice(index2, 1);
    await Room.update({ channel: room.channel }, { where: { id: roomId } });
    return res.json(true)
  } catch (error) {
    res.status(500).send("error");
  }
};

const removeRoom = async (req, res) => {
  const { roomId } = req.params;
  console.log('서버연결성공!!!!', roomId)
  try {
    const room = await Room.destroy({ where: { id: roomId } });
  } catch (error) {
    res.status(500).send("error");
  }
};

const makeChannel = async (req, res) => {
  const { id, channelName, number } = req.body;
  console.log(req.body);
  const room = await Room.findOne({ where: { id: id } });
  room.channel.push({[channelName] : []});
  await Room.update({channel:room.channel},{where: {id: id}});
  return res.json(true);
};

const channelDelete = async (req, res) => {
  const { id,  number } = req.body;
  const room = await Room.findOne({ where: { id: id } });
  room.channel.splice(number, 1 );
  await Room.update({channel:room.channel},{where: {id: id}});
  return res.json(true);
};

export default {
  joinRoom,
  roomImgUpload,
  createRoom,
  getRoom,
  exitRoom,
  changename,
  joinChannel,
  doubleJoin,
  update,
  makeChannel,
  channelDelete,
  removeRoom,
};
