import { User } from "../models/index.js";
import jwt from "jsonwebtoken";
import config from "../config/app.config.js";

const multer = require('multer');
const uploadimg = multer({ dest: 'uploads/' });

const imgUpload = uploadimg.fields([
    { name: 'avatarUrl', maxCount: 1 }
])

const update = async (req, res) => {
  try {
       const avatar = req.files['avatarUrl'][0]
       const avatarUrl = avatar.filename
       console.log(avatarUrl)
       await User.update({'img':avatarUrl},{where :{id:'9999'}} )
       const userId = await User.findOne({where : {id:'9999'}})
       return res.json(userId)
  } catch (error) {
      console.log(error);
      res.status(500).send('이미지 업데이트 실패')
  }
}

const login = async (req, res) => {
  try {
    console.log("login= ", req.body);
    const { email, password } = req.body;
    const user = await User.findOne({ where: { email: email } });
    if (!user)
      return res.status(422).send(`${email} 사용자가 존재하지 않습니다.`);

    const passworMatch = await user.comparePassword(password);
    if (passworMatch) {
      const token = jwt.sign({ userID: user.id }, config.jwtSecret, {
        expiresIn: config.jwtExpires,
      });
      res.cookie(config.cookieName, token, {
        path: "/",
        httpOnly: true,
        secure: true,
      });
      res.json({ user });
    } else {
      res.status(401).send("비밀번호가 일치하지 않습니다.");
    }
  } catch (error) {
    console.log(error);
    return res.status(500).send("로그인 중 에러");
  }
};

const signup = async (req, res) => {
  try {
    console.log("sign up= ", req.body);
    const { id, name, email, password, gender, phone } = req.body;
    const user = User.create({ id, name, email, password, gender, phone });
  } catch (error) {
    console.log(error);
    return res.status(500).send("회원가입 중 에러");
  }
};

export default {
  login,
  signup,
  imgUpload,
  update,
};
