import ScreenSelect from './ScreenSelect'
import video_btn from '../../videobtn.png'
import speaker_btn from '../../speakerbtn.png'
import mic_btn from '../../micbtn.png'
import videooff_btn from '../../videooffbtn.png'
import speakeroff_btn from '../../speakeroffbtn.png'
import micoff_btn from '../../micoffbtn.png'
import React, { useState } from 'react';

const Controller = () => {
  const [mic, setMic] = useState("true")
  const [video, setVideo] = useState("true")
  const [speaker, setSpeaker] = useState("true")

  const micOn = (() => setMic(false));
  const micOff = (() => setMic(true));
  const speakerOn = (() => setSpeaker(false));
  const speakerOff = (() => setSpeaker(true));
  const videoOn = (() => setVideo(false));
  const videoOff = (() => setVideo(true));

  return (
    <div className="container">
      <div className="row">
        <div
          className="col d-flex justify-content-center"
          style={{ backgroundColor: '#C4C4C4', position: 'absolute', bottom: 0, width:'414px' }}
        >
          {mic ? <div className="col d-flex justify-content-center">
            <button type="button" className="btn" onClick={micOn}>
              <img src={micoff_btn} width="45" height="40" />
            </button>
          </div>
            : <div className="col d-flex justify-content-center">
              <button type="button" className="btn" onClick={micOff}>
                <img src={mic_btn} width="45" height="40" />
              </button>
            </div>
          }
          {speaker ? <div className="col d-flex justify-content-center">
            <button type="button" className="btn" onClick={speakerOn}>
              <img src={speakeroff_btn} width="45" />
            </button>
          </div> : <div className="col d-flex justify-content-center">
            <button type="button" className="btn" onClick={speakerOff}>
              <img src={speaker_btn} width="45" />
            </button>
          </div>
          }
          {video ? <div className="col d-flex justify-content-center">
            <button
              type="button"
              className="btn"
              data-bs-toggle="modal"
              data-bs-target="#exampleModal"
              src={video_btn}
              onClick="location.href='ScreenSelect.js'"
              onClick={videoOn}
            >
              <img src={videooff_btn} width="45" />
            </button>
          </div> :
            <div className="col d-flex justify-content-center">
              <button type="button" className="btn" onClick={videoOff}>
                <img src={video_btn} width="45" />
              </button>
            </div>}
        </div>
        <ScreenSelect />
      </div>
    </div>
  )
}

export default Controller
