import { useEffect, useState } from "react";

const INIT_USER = {
  name: "",
  idNumber1: "",
  idNumber2: "",
  id: "",
  password: "",
  checkpw: "",
  phone: "",
};

const Signup = () => {
  const [user, setUser] = useState(INIT_USER);
  const [error, setError] = useState("");
  const [success, setSuccess] = useState(false);
  let disabled = false;

  useEffect(() => {
    disabled = !(
      user.name &&
      user.idNumber1 &&
      user.idNumber2 &&
      user.id &&
      user.password &&
      user.checkpw
    );
  }, [user]);

  function handleChange(event) {
    const { name, value } = event.target;
    setUser({ ...user, [name]: value });
    console.log(user);
  }

  async function handleSubmit() {
    try {
      // setLoading(true);
      // setError("");
      //   const success = await login(user.email, user.password);
      console.log(user);
      setSuccess(success);
    } catch (error) {
      // catchErrors(error, setError);
    } finally {
      // setLoading(false);
    }
  }

  const { name, idNumber1, idNumber2, id, password, checkpw, phone } = user;
  return (
    <div className="modal-content">
      <form onSubmit={handleSubmit}>
        <div className="modal-header">
          <h5 className="modal-title" id="loginModalLabel">
            회원가입
          </h5>
          <button
            type="button"
            className="btn-close"
            data-bs-dismiss="modal"
            aria-label="Close"
          ></button>
        </div>
        <div className="modal-body">
          <div className="p-2">
            <label className="p-1">이름</label>
            <input
              className="form-control"
              id="name"
              type="text"
              name="name"
              placeholder="이름을 입력하세요"
              value={name}
              onChange={handleChange}
            />
          </div>
          <div className="p-2">
            <label className="p-1">주민등록번호</label>
            <div className="d-flex text-center">
              <div className="col-4">
                <input
                  className="mt-2 form-control"
                  id="idNumber1"
                  type="text"
                  name="idNumber1"
                  placeholder="●●●●●●"
                  maxLength='6'
                  value={idNumber1}
                  onChange={handleChange}
                />
              </div>
              <div className="col-1 pt-3 ps-2">ㅡ</div>
              <div className="col-1">
                <input
                  className="mt-2 ms-2 form-control"
                  id="idNumber2"
                  type="text"
                  style={{width:'35px'}}
                  name="idNumber2"
                  placeholder="●"
                  value={idNumber2}
                  onChange={handleChange}
                  maxLength='1'
                />
              </div>
              <div className="pt-3 ps-4">* * * * * *</div>
            </div>
          </div>
          <div className="p-2">
            <label className="p-1">아이디</label>
            <input
              className="form-control"
              id="id"
              type="text"
              name="id"
              placeholder="아이디를 입력하세요"
              value={id}
              onChange={handleChange}
            />
          </div>
          <div className="p-2">
            <label className="p-1">비밀번호</label>
            <input
              className="form-control"
              id="password"
              type="password"
              name="password"
              placeholder="비밀번호를 입력하세요"
              value={password}
              onChange={handleChange}
            />
          </div>
          <div className="p-2">
            <label className="p-1">비밀번호확인</label>
            <input
              className="form-control"
              id="checkpw"
              type="password"
              name="checkpw"
              placeholder="비밀번호를 다시 입력하세요"
              value={checkpw}
              onChange={handleChange}
            />
          </div>
          <div className="p-2">
            <label className="p-1">전화번호(선택)</label>
            <input
              className="form-control"
              id="phone"
              type="text"
              name="phone"
              placeholder="'-'을 제외하고 입력하세요"
              value={phone}
              onChange={handleChange}
            />
          </div>
        </div>
        <div className="modal-footer">
          <button type="submit" className="btn btn-primary" disabled={disabled}>
            회원가입
          </button>
        </div>
      </form>
    </div>
  );
};

export default Signup;
