import React, { useState, useEffect } from "react";
import { Link, useParams } from "react-router-dom";
import ChannelSingle from "./ChannelSingle";
import RoomApi from "../../apis/room.api";
import catchErrors from "../../context/catchError";
import KakaoShareButton from "../KakaoShareButton";
import Roomnamechange from "./Roomnamechange";

const INIT_ROOM = {
  name: "",
  owner: "",
};

const INIT_CHANNEL = {
  channelName: "",
  joinUser: [],
};
const RightHamburger = () => {
  const [channel, setChannel] = useState([INIT_CHANNEL]);
  const [room, setRoom] = useState([INIT_ROOM]);
  const { roomId } = useParams();
  const [error, setError] = useState("");
  const id = localStorage.getItem("user");

  async function getRoom(roomId) {
    try {
      const data = await RoomApi.getRoom([roomId]);
      const roomdata = [];
      roomdata.push({
        name: data[0].name,
        owner: data[0].owner,
      });
      console.log(roomdata);
      setRoom(roomdata);
    } catch (error) {
      catchErrors(error, setError);
    }
  }

  async function exitRoom() {
    console.log("id, roomid정보", id, roomId);
    try {
      const data = await RoomApi.exitRoom({ id, roomId });
    } catch (error) {
      catchErrors(error, setError);
    }
  }

  async function getChannel(roomId) {
    try {
      const data = await RoomApi.getRoom([roomId]);
      const Channel = data[0].channel;
      const channelList = [];
      for (const prop in Channel) {
        // Channel의 항목(prop)으로 작업을 실행합니다
        for (const el in Channel[prop]) {
          channelList.push({
            channelName: el,
            joinUser: Channel[prop][el],
          });
        }
      }
      setChannel(channelList);
    } catch (error) {
      catchErrors(error, setError);
    }
  }

  // console.log(channel)

  useEffect(() => {
    getChannel(roomId);
    getRoom(roomId);
  }, [roomId]);

  function roomIdCopy() {
    const t = document.querySelector("#roomId").innerText;
    console.log(t);
    navigator.clipboard.writeText(t);
    document.execCommand("copy");
  }
  return (
    <div>
      <div>
        <button
          className="navbar-toggler"
          type="button"
          data-bs-toggle="offcanvas"
          data-bs-target="#right-hamburger"
          aria-controls="right-hamburger"
          aria-expanded="false"
          aria-label="Toggle navigation"
          style={{ border: "#f4c1f2" }}
        >
          <img src="/RightHamburgerImg.png" width="50px" height="30px" />
        </button>
      </div>
      <div
        className="offcanvas offcanvas-end"
        style={{ width: "330px" }}
        tabIndex="-1"
        id="right-hamburger"
        aria-labelledby="hamburgerLabel"
      >
        <div className="offcanvas-header">
          <p
            className="col-6 offcanvas-title"
            id="offcanvasExampleLabel"
            style={{
              fontWeight: "bold",
              fontSize: "15px",
              overflow: "hidden",
              whiteSpace: "nowrap",
              width: "150px",
              color: "#000000",
            }}
          >
            {room[0].name}
          </p>
          <h6 className="mt-2" id="roomId">
            {" "}
            {`${roomId}`}{" "}
          </h6>
          <button
            type="button"
            className="btn-close text-reset"
            data-bs-dismiss="offcanvas"
            aria-label="Close"
          ></button>
        </div>
        <div>
          <ChannelSingle channel={channel} />
          <div className="d-flex flex-row-reverse">
            <button
              type="button"
              className="m-3 rounded"
              data-bs-toggle="modal"
              data-bs-target="#inviteRoom"
              style={{
                height: "30px",
                fontWeight: "bold",
                backgroundColor: "#E0CEE8",
                color: "black",
                border: "1px #D64D61",
              }}
            >
              초대
            </button>
            <div
              className="modal fade"
              id="inviteRoom"
              tabIndex="-1"
              aria-labelledby="exitRoomLabel"
              aria-hidden="true"
            >
              <div className="modal-dialog">
                <div className="modal-content">
                  <div className="modal-header">
                    <button
                      type="button"
                      className="btn-close"
                      data-bs-dismiss="modal"
                      aria-label="Close"
                    ></button>
                  </div>
                  <div className="modal-body d-flex justify-content-center">
                    어떤 방식으로 초대하시겠습니까?
                  </div>
                  <div className="row mb-3">
                    <div className="d-flex justify-content-evenly">
                      <KakaoShareButton />
                      <button
                        type="submit"
                        className="col-2 p-1 btn btn-primary"
                        data-bs-dismiss="modal"
                        style={{ width: "120px" }}
                        onClick={roomIdCopy}
                      >
                        방 Id 복사
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div className="d-flex flex-row-reverse">
              <button
                type="button"
                className="m-3 rounded text-white"
                data-bs-toggle="modal"
                data-bs-target="#exitRoom"
                style={{
                  height: "30px",
                  fontWeight: "bold",
                  backgroundColor: "#d86da6",
                  color: "black",
                  border: "1px #d86da6",
                }}
              >
                퇴장
              </button>
              {room[0].owner == id ? (
                <button
                  type="button"
                  className="m-3 rounded"
                  data-bs-toggle="modal"
                  data-bs-target="#Roomsetting"
                  style={{
                    height: "30px",
                    fontWeight: "bold",
                    backgroundColor: "#E0CEE8",
                    color: "black",
                    border: "1px #D64D61",
                  }}
                >
                  설정
                </button>
              ) : null}

              <div
                className="modal fade"
                id="Roomsetting"
                tabIndex="-1"
                aria-labelledby="RoomsettingLabel"
                aria-hidden="true"
              >
                <div className="modal-dialog">
                  <div className="modal-content">
                    <div className="modal-header">
                      <button
                        type="button"
                        className="btn-close"
                        data-bs-dismiss="modal"
                        aria-label="Close"
                      ></button>
                    </div>
                    <div className="modal-body d-flex justify-content-center">
                      어떤 설정을 하시겠습니까?
                    </div>
                    <div className="row mb-3">
                      <div className="d-flex justify-content-evenly">
                        {/* <button
                          type="submit"
                          data-bs-dismiss="modal"
                          style={{
                            weight: "100px",
                            height: "60px",
                            backgroundColor: "#f5cfe3",
                            borderRadius: "5px",
                            color: "black",
                            border: "1px #f5cfe3",
                          }}
                        >
                          채널 이름 변경
                        </button> */}
                        <Roomnamechange />
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div
                className="modal fade"
                id="exitRoom"
                tabIndex="-1"
                aria-labelledby="exitRoomLabel"
                aria-hidden="true"
              >
                <div className="modal-dialog">
                  <div className="modal-content">
                    <div className="modal-header">
                      <button
                        type="button"
                        className="btn-close"
                        data-bs-dismiss="modal"
                        aria-label="Close"
                      ></button>
                    </div>
                    <div className="modal-body d-flex justify-content-center">
                      이방에서 퇴장하시겠습니까?
                    </div>
                    <div className="row mb-3">
                      <div className="d-flex justify-content-evenly">
                        <Link
                          to={`/user/${id}`}
                          className="col-2 p-1 btn btn-primary"
                        >
                          <button
                            type="button"
                            onClick={exitRoom}
                            className="btn btn-primary"
                            data-bs-dismiss="modal"
                          >
                            예
                          </button>
                        </Link>
                        <button
                          type="submit"
                          className="btn btn-primary"
                          data-bs-dismiss="modal"
                        >
                          아니요
                        </button>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default RightHamburger;
