import { useEffect, useState } from 'react';
import { Link } from 'react-router-dom'
import roomApi from '../../apis/room.api';
import userApi from '../../apis/user.api';
import catchErrors from '../../context/catchError';

const id = localStorage.getItem('user');
const INIT_ROOM={
  name:"",
  profileimg:"",
  member:"",
}
const RoomSingle = () => {
  const [room, setRoom] = useState(INIT_ROOM)
  const [error,setError]=useState('')
  const channelId = 1
  const roomId = "1234567abc"

  async function getJoinRoom(Id) {
    try {
      const User = await userApi.getUser(Id)
      const RoomNumArr = User.roomNumber
      const Room= await roomApi.getRoom(RoomNumArr)
      console.log(Room[0])
      const rrr=Room[0]
      const memcount= rrr.member.length
      setRoom({...room, name:rrr.name, profileimg: rrr.profileimg, member:memcount})
      console.log(room)

    } catch (error) {
      catchErrors(error, setError)
    }
  }

  useEffect(() => {
    getJoinRoom(id)
  }, [id])

  return (
    <Link
      to={`/room/${id}/${channelId}`}
      className="text-decoration-none text-dark"
    >
      <div
        className="d-flex mx-4 my-2 p-2"
        style={{ backgroundColor: '#C4C4C4' }}
      >
        <div style={{ width: '37px', height: '37px' }}>
          {/* <img
            src={`/roomUploads/${profileimg}`}
            className="rounded-circle"
            style={{ width: '37px', height: '37px' }}
          /> */}
        </div>
        <div
          className="mx-3 mt-2"
          style={{
            width: '250px',
            overflow:'scroll',
            whiteSpace: 'nowrap',
            msOverflowStyle:'none',
          }}
        >
          {room.name}
        </div>
        <div className="ms-auto mt-2"> {room.member}/100 </div>
      </div>

    </Link>
  )
}

export default RoomSingle
