// server 진입점
import dotenv from "dotenv";
import app from "./app.js";
import appConfig from "./config/app.config.js";
import { sequelize, User } from "./models/index.js";

dotenv.config({
  path: `${
    process.env.NODE_ENV === "production" ? ".env" : ".env.development"
  }`,
});

sequelize
  .sync({ force: true })
  .then(async () => {
    console.log(" DB 연결 성공");
    await User.create({
      id: 9999,
      name: "admin",
      email: "admin",
      password: "admin!",
      gender: 0,
    });

    app.listen(appConfig.port, () => {
      console.log(`Server is running on port ${appConfig.port}`);
    });
  })
  .catch((err) => {
    console.log("연결 실패");
    console.log(err);
  });

// production
// sequelize.sync().then(() => {
//   app.listen(appConfig.port, () => {
//     console.log(`Server is running on port ${appConfig.port}`)
//   })
// })

// development
// 주의!!!: {force: true}는 서버가 다시 시작되면 기존 디비 모두 삭제되고 새로운 디비 생성
// sequelize
//   .sync({ force: true })
//   .then(async () => {
//     // await Promise.all(
//     //   Object.keys(ROLE_NAME).map((name) => {
//     //     return Role.create({ name });
//     //   })
//     // );

//     // const adminRole = await Role.findOne({ where: { name: "admin" } });

//     await User.create({
//       id: "0000",
//       name: "admin",
//       email: "admin",
//       password: "admin!",
//       gender: 0,
//     });

//     app.listen(appConfig.port, () => {
//       console.log(`Server is running on port ${appConfig.port}`);
//     });
//   })
//   .catch((err) => {
//     console.log(err);
//   });
