import { useState } from "react";
import { useParams } from "react-router-dom";
import roomApi from "../../apis/room.api";
import catchErrors from "../../context/catchError";


const MakeChannel = () => {
    const { roomId } = useParams();
    const [channelName, setChannelName] = useState("");
    const [error, setError] = useState("");
    const [success, setSuccess] = useState(false);

    function handleChange(event) {
        const { value } = event.target;
        setChannelName(value);
    }
    console.log(channelName)

    async function handleSubmit(e) {
        // e.preventDefault();
        try {
            const data = await roomApi.makeChannel({ roomId: roomId, channelName: channelName });
            console.log('서버연결됬나요', data)
            setSuccess(true);
        } catch (error) {
            catchErrors(error, setError);
        } finally {
            // setLoading(false);
        }
    }

    if (success) {
        // console.log('success', success)
        alert('채널생성이 완료되었습니다!')
        window.location.href = `/room/${roomId}/${channelName}`
    }

    return (
        <div className="modal-content">
            <form
                onSubmit={handleSubmit}
            >
                <div className="modal-header">
                    <div className="modal-title" id="MakeChannelModal">
                        채널 생성하기
                    </div>
                    <button
                        type="button"
                        className="btn-close"
                        data-bs-dismiss="modal"
                        aria-label="Close"
                    ></button>
                </div>
                <div className="modal-body">
                    {error && <div className="alert alert-danger">{error}</div>}
                    <div className="input-group mb-3">
                        <input
                            type="text"
                            className="form-control"
                            placeholder="생성할 채널이름을 입력하세요"
                            aria-label="생성할 채널이름을 입력하세요"
                            aria-describedby="basic-addon1"
                            name="channelName"
                            value={channelName}
                            onChange={handleChange}
                        />
                    </div>
                    <div className="modal-footer">
                        <button
                            type="submit"
                            className="btn btn-primary">
                            확인
                        </button>
                    </div>
                </div>
            </form>
        </div>
    );
};

export default MakeChannel;
