import { useState } from 'react'
import { Link, useParams } from 'react-router-dom'
import roomApi from '../../apis/room.api';
import userApi from '../../apis/user.api'
import catchErrors from "../../context/catchError";

const ChannelSingle = (props) => {
  const [error, setError] = useState("");
  const [success, setSuccess] = useState(false);
  const [roomName, setRoomName] = useState('');
  const { roomId, channelId } = useParams();
  const userId = localStorage.getItem('user')


  async function joinChannel(e) {
    console.log(e, userId)
    try {
      const data = await userApi.getUser(userId);
      const index1 = indexCheck(e)
      const A = doubleJoinCheck(data.name)
      const mem = props.channel[index1].joinUser
      const joinCh = mem.includes(data.name);
      if (!joinCh) {
        if (A) {
          await roomApi.doubleJoin({ roomId: roomId, index1: A.index1, index2: A.index2, joinChName: A.joinChName })
        }
        const roomA = await roomApi.joinChannel({ roomId: roomId, channelName: e, plusUser: data.name, index: index1 })
        setRoomName(e)
        setSuccess(true)
      } else {
        alert('이미 참여된 채널입니다.')
      }
    } catch (error) {
      catchErrors(error, setError);
    }
  }

  function indexCheck(e) {
    for (const index1 in props.channel) {
      if (props.channel[index1].channelName === e) {
        return index1
      }
    }
  }

  function doubleJoinCheck(e) {
    for (const index in props.channel) {
      for (const el in props.channel[index].joinUser) {
        if (props.channel[index].joinUser[el] === e) {
          const doublejoinCh = props.channel[index].channelName
          const A = {
            index1: index,
            index2: el,
            joinChName: doublejoinCh,
          }
          return A
        }
      }
    }
  }

  if (success) {
    alert(`${roomName} 채널에 참가되었습니다.`)
    window.location.href = `/room/${roomId}/${roomName}`
  }

  return (
    <div>
      <div className="overflow-auto" style={{ height: '610px' }}>
        {props.channel.map((el,i) => (
          <div className="mb-3" key={`channel${i}`}>
            <Link to={`/room/${roomId}/${el.channelName}`}>
              <div
                className="m-3 p-1 row"
                style={{ backgroundColor: '#E0CEE8' }}
                onClick={() => joinChannel(el.channelName)}
              >
                {el.channelName === channelId ? (
                  <img
                    className="col-auto mt-2"
                    src="/fullSpeaker.png"
                    width="25px"
                    height="25px"
                  />
                ) : (
                  <img
                    className="col-auto mt-2"
                    src="/emptySpeaker.png"
                    width="25px"
                    height="25px"
                  />
                )}
                <h5 className="col mt-2" style={{ color: 'black' }}>
                  {el.channelName}
                </h5>
              </div>
            </Link>

            {el.joinName &&
              el.joinName.map((e,i) => (
                <div key={`member${i}`}>
                  <ul className="mx-5" style={{ color: '#76D079' }}>
                    <li>
                      <p style={{ color: 'black' }}>{e}</p>
                    </li>
                  </ul>
                </div>
              ))}
          </div>
        ))}
      </div>
    </div>
  )
}

export default ChannelSingle