import { useEffect, useState } from "react";
import catchErrors from "../../context/catchError";
import { useParams } from "react-router-dom";
import roomApi from "../../apis/room.api";

const INIT_ROOM = {
  id: "",
  name: "",
  profileimg: "",
};

const InitRoom = () => {
  const { roomId } = useParams();
  const [room, setRoom] = useState(INIT_ROOM);
  const [error, setError] = useState("");

  async function getRoom(roomId) {
    try {
      const data = await roomApi.getRoom([roomId]);
      setRoom(data[0]);
    } catch (error) {
      catchErrors(error, setError);
    }
  }

  useEffect(() => {
    getRoom(roomId);
  }, [roomId]);

  return (
    <div>
      <div
        style={{ backgroundColor: "#262626", width: "auto", height: "2px" }}
      />
      <form className="flex-row align-items-center justify-content-center m-5">
        <div className="d-flex justify-content-center">
          <img
            src={`/roomUploads/${room.profileimg}`}
            className="rounded-circle"
            style={{
              width: "250px",
              height: "250px",
            }}
          />
        </div>
        <div className="row">
          <div className="col-3"></div>
          <div className="col-6 my-5">
            <h2
              className="mb-3"
              style={{ fontSize: "13px", fontWeight: "bold" }}
            >
              방 이름
            </h2>
            <h2
              className="mb-4 mt-2"
              style={{ fontSize: "25px", fontWeight: "bold" }}
            >
              {room.name}
            </h2>
            <h2
              className="mb-3 mt-2"
              style={{ fontSize: "13px", fontWeight: "bold" }}
            >
              방 코드
            </h2>
            <h2
              className="mb-3 mt-2"
              style={{ fontSize: "25px", fontWeight: "bold" }}
            >
              {room.id}
            </h2>
          </div>
          <div className="col"></div>
        </div>
      </form>
    </div>
  );
};

export default InitRoom;
