import { Link, Route, Switch, useParams } from "react-router-dom";

const ChannelSingle = () => {
  const { roomId } = useParams();
  return (
    <div className="overflow-auto" style={{ height: "610px" }}>
      <div className="mb-3">
        <div className="m-3 p-1 row" style={{ backgroundColor: "#E0CEE8" }}>
          <Link to={`${roomId}/meeting`}>
            <img
              className="col-auto mt-2"
              src="/fullSpeaker.png"
              width="25px"
              height="25px"
            />
            <h5 className="col mt-2" style={{ color: "black" }}>
              회의
            </h5>
          </Link>
        </div>
        <ul className="mx-5" style={{ color: "#76D079" }}>
          <li>
            <p style={{ color: "black" }}>CHERRY</p>
          </li>
          <li>
            <p style={{ color: "black" }}>JAEYEON</p>
          </li>
          <li>
            <p style={{ color: "black" }}>SEOYEON</p>
          </li>
          <li>
            <p style={{ color: "black" }}>JIWEON</p>
          </li>
          <li>
            <p style={{ color: "black" }}>BYOUNGYUN</p>
          </li>
        </ul>
      </div>

      <div className="mb-3">
        <div className="m-3 p-1 row" style={{ backgroundColor: "#E0CEE8" }}>
          <img
            className="col-auto mt-2"
            src="/emptySpeaker.png"
            width="25px"
            height="25px"
          />
          <Link to={`${roomId}/normal`}>
            <h5 className="col mt-2" style={{ color: "black" }}>
              일반
            </h5>
          </Link>
        </div>
        <ul className="mx-5" style={{ color: "#76D079" }}>
          <li>
            <p style={{ color: "black" }}>CHERRY</p>
          </li>
          <li>
            <p style={{ color: "black" }}>JAEYEON</p>
          </li>
          <li>
            <p style={{ color: "black" }}>SEOYEON</p>
          </li>
          <li>
            <p style={{ color: "black" }}>JIWEON</p>
          </li>
          <li>
            <p style={{ color: "black" }}>BYOUNGYUN</p>
          </li>
        </ul>
      </div>

      <div className="mb-3">
        <div className="m-3 p-1 row" style={{ backgroundColor: "#E0CEE8" }}>
          <img
            className="col-auto mt-2"
            src="/emptySpeaker.png"
            width="25px"
            height="25px"
          />
          <Link to={`${roomId}/notice`}>
            <h5 className="col mt-2" style={{ color: "black" }}>
              공지
            </h5>
          </Link>
        </div>
        <ul className="mx-5" style={{ color: "#76D079" }}>
          <li>
            <p style={{ color: "black" }}>CHERRY</p>
          </li>
          <li>
            <p style={{ color: "black" }}>JAEYEON</p>
          </li>
          <li>
            <p style={{ color: "black" }}>SEOYEON</p>
          </li>
          <li>
            <p style={{ color: "black" }}>JIWEON</p>
          </li>
          <li>
            <p style={{ color: "black" }}>BYOUNGYUN</p>
          </li>
        </ul>
      </div>
    </div>
  );
};

export default ChannelSingle;
