import axios from "axios";

const getRoom = async (id) => {
  const { data } = await axios.get(`/api/room/getRoom/${id}`);
  return data;
};

const create = async (payload) => {
  const { data } = await axios.post("/api/room/create", payload);
  return data;
};

const join = async (payload) => {
  const { data } = await axios.put("/api/room/join", payload);
  return data;
};

const roomApi = { getRoom, create, join };

export default roomApi;
