import bcrypt from "bcryptjs";
import { DataTypes } from "sequelize";
// import img from 'bora_it\client\public\user.png'

const UserModel = (sequelize) => {
  const User = sequelize.define(
    "user",
    {
      id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
      },
      name: {
        type: DataTypes.STRING,
      },
      email: {
        type: DataTypes.STRING,
      },
      password: {
        type: DataTypes.STRING,
      },
      gender: {
        type: DataTypes.INTEGER,
      },
      phone: {
        type: DataTypes.STRING,
      },
      img: {
        type: DataTypes.STRING,
        defaultValue:'defaultimg'
      },
      roomNumber: {
        type: DataTypes.ARRAY(DataTypes.STRING),
      },
    },
    { timestamps: true }
  );

  User.beforeSave(async (user) => {
    if (!user.changed("password")) {
      return;
    }

    if (user.password) {
      const hashedPassword = await bcrypt.hash(user.password, 10);
      user.password = hashedPassword;
    }
  });

  User.prototype.toJSON = function toJSON() {
    const values = Object.assign({}, this.get());

    delete values.password;
    return values;
  };

  User.prototype.comparePassword = async function (plainPassword) {
    const passwordMatch = await bcrypt.compare(plainPassword, this.password);
    return passwordMatch;
  };

  return User;
};

export default UserModel;
