import { useState, useEffect } from "react";
import { useParams } from "react-router-dom";
import ChannelSingle from './ChannelSingle';
import Rightimg from '../../images/RightHamburgerImg.png'
import RoomApi from "../../apis/room.api";

// const INIT_Room = {
//     id: '',
//     name: '',
//     member: '',
//     profileimg: '',
//     channel: ''
//   }

const RightHamburger = () => {
    const [admin, setAdmin] = useState('true')
    const { roomId } = useParams();
    // const [Room, setRoom] = useState(INIT_Room)
    // async function Roomstate(Roomid) {
    //     try {
    //       const data = await RoomApi.getRoom(Roomid)
    //         console.log("여기 데이터 표시")
    //       setRoom(data)
    //     } catch (error) {
    //       // catchErrors(error, setError)
    //     }
    //   }
    
    //   useEffect(() => {
    //     Roomstate(link[4])
    //   }, []) 이거 getRoom이 작동 안하는것 같다.
    /*
    1. 서버에서 현재 입장한 Roomid 받아다가 보여주기(좌,우 공통)
    2. Roomid확인 후 그 방의 channel 받아다가 보여주기(각 채널과, 그 안에 있는 사람들. 이때, 각 채널은 일종의 버튼이고, 클릭하면 거기로 나의 정보를 옮긴다.)
    3. 서버에서 로그인 on/off 구분해서 받아다가 일치하는 userid가 있으면 그사람의 on/off요소 보여주기
    */
    return (
        <div>
            <div>
                <button
                    className="navbar-toggler"
                    type="button"
                    data-bs-toggle="offcanvas"
                    data-bs-target="#right-hamburger"
                    aria-controls="right-hamburger"
                    aria-expanded="false"
                    aria-label="Toggle navigation"
                    style={{ border: '#f4c1f2' }}
                >
                    <img src={Rightimg} width="50px" height="30px"/>
                </button>
            </div>
            <div
                className="offcanvas offcanvas-end"
                style={{ width: '330px' }}
                tabIndex="-1"
                id="right-hamburger"
                aria-labelledby="hamburgerLabel"
            >
                <div className="offcanvas-header">
                    <p
                        className="col-6 offcanvas-title"
                        id="offcanvasExampleLabel"
                        style={{
                            fontWeight: 'bold',
                            fontSize: '15px',
                            overflow: 'hidden',
                            whiteSpace: 'nowrap',
                            width: '150px',
                            color: '#000000',
                        }}
                    >
                        방 이름{/*Room.name*/}
                    </p>
                    <h6 className="mt-2" id="roomId" > {`${roomId}`} </h6>
                    <button
                        type="button"
                        className="btn-close text-reset"
                        data-bs-dismiss="offcanvas"
                        aria-label="Close"
                    ></button>
                </div>

                <ChannelSingle />
                <div>
                    <div className="d-flex flex-row-reverse">
                        <button
                            type="button"
                            className="m-3 rounded text-white"
                            data-bs-toggle="modal"
                            data-bs-target="#exitRoom"
                            style={{
                                height: '30px',
                                fontWeight: 'bold',
                                backgroundColor: '#d86da6',
                                color: 'black',
                                border: '1px #d86da6',
                            }}
                        >
                            퇴장    
                        </button>
                        {admin ? <button
                            type="button"
                            className="m-3 rounded"
                            style={{
                                height: '30px',
                                fontWeight: 'bold',
                                backgroundColor: '#E0CEE8',
                                color: 'black',
                                border: '1px #D64D61',
                            }}
                        >
                            설정
                        </button> : null}
                        
                        <div
                            className="modal fade"
                            id="exitRoom"
                            tabIndex="-1"
                            aria-labelledby="exitRoomLabel"
                            aria-hidden="true"
                        >
                            <div className="modal-dialog">
                                <div className="modal-content">
                                    <div className="modal-header">
                                        <button
                                            type="button"
                                            className="btn-close"
                                            data-bs-dismiss="modal"
                                            aria-label="Close"
                                        ></button>
                                    </div>
                                    <div className="modal-body d-flex justify-content-center">
                                        이방에서 퇴장하시겠습니까?
                                    </div>
                                    <div className="row mb-3">
                                        <div className="d-flex justify-content-evenly">
                                            {/* <Link to="/user"> */}
                                            <button
                                                type="submit"
                                                className="col-2 p-1 btn btn-primary"
                                                data-bs-dismiss="modal"
                                            >
                                                예
                                            </button>
                                            {/* </Link> */}
                                            <button
                                                type="submit"
                                                className="col-2 p-1 btn btn-primary"
                                                data-bs-dismiss="modal"
                                            >
                                                아니요
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div >
    )


}

export default RightHamburger