import UserState from "./UserState";
import { Link, useParams } from "react-router-dom";
import KakaoShareButton from "../KakaoShareButton";
import { useEffect } from "react";

const LeftHamburger = () => {
  const { roomId } = useParams();
  useEffect(() => {
    const script = document.createElement("script");
    script.src = "https://developers.kakao.com/sdk/js/kakao.js";
    script.async = true;
    document.body.appendChild(script);
    return () => {
      document.body.removeChild(script);
    };
  }, []);

  function roomIdCopy() {
    navigator.clipboard.writeText(link[4]);
    //document.execCommand("copy");
  }

  return (
    <div>
      <div>
        <button
          className="navbar-toggler"
          type="button"
          data-bs-toggle="offcanvas"
          data-bs-target="#left-hamburger"
          aria-controls="left-hamburger"
          aria-expanded="false"
          aria-label="Toggle navigation"
          style={{ border: "#f4c1f2" }}
        >
          <span className="navbar-toggler-icon"></span>
        </button>
      </div>

      <div
        className="offcanvas offcanvas-start"
        style={{ width: "330px" }}
        tabIndex="-1"
        id="left-hamburger"
        aria-labelledby="hamburgerLabel"
      >
        <div className="offcanvas-header">
          <p
            className="col-6 offcanvas-title"
            id="offcanvasExampleLabel"
            style={{
              fontWeight: "bold",
              fontSize: "15px",
              width: "150px",
              color: "#000000",
            }}
          >
            온/오프라인 사용자
          </p>
          <h6 className="mt-2" id="roomId">
            {`${roomId}`}
          </h6>
        </div>
        <UserState />
        <div>
          <div className="d-flex flex-row-reverse">
            <button
              type="button"
              className="m-3 rounded"
              data-bs-toggle="modal"
              data-bs-target="#InviteRoom"
              style={{
                height: "30px",
                fontWeight: "bold",
                backgroundColor: "#E0CEE8",
                color: "black",
                border: "1px #D64D61",
              }}
            >
              초대
            </button>
            <div
              className="modal fade"
              id="InviteRoom"
              tabIndex="-1"
              aria-labelledby="InviteRoomLabel"
              aria-hidden="true"
            >
              <div className="modal-dialog">
                <div className="modal-content">
                  <div className="modal-header">
                    <button
                      type="button"
                      className="btn-close"
                      data-bs-dismiss="modal"
                      aria-label="Close"
                    ></button>
                  </div>
                  <div className="modal-body d-flex justify-content-center">
                    어떤 방식으로 초대하시겠습니까?
                  </div>
                  <div className="row mb-3">
                    <div className="d-flex justify-content-evenly">
                      {/* <button
                        type="submit"
                        className="col-2 p-1 btn btn-primary"
                        data-bs-dismiss="modal"
                        style={{ width: "120px" }}
                        onClick={KakaoCode}
                      >
                      카카오로 초대
                      </button> */}
                      <KakaoShareButton />
                      <button
                        type="submit"
                        className="col-2 p-1 btn btn-primary"
                        data-bs-dismiss="modal"
                        style={{ width: "120px" }}
                        onClick={roomIdCopy}
                      >
                        방 Id 복사
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default LeftHamburger;
