import pkg from 'sequelize';
const { DataTypes } = pkg;

const RoomModel = (sequelize) => {
  const Room = sequelize.define(
    "room",
    {
      id: {
        type: DataTypes.STRING,
        primaryKey: true,
      },
      name: {
        type: DataTypes.STRING,
      },
      owner: {
        type: DataTypes.INTEGER,
      },
      member: {
        type: DataTypes.ARRAY(DataTypes.STRING),
      },
      profileimg: {
        type: DataTypes.STRING,
        // defaultValue: "defaultimg"
      },
      channel: {
        type: DataTypes.ARRAY(DataTypes.JSON),
        defaultValue: [{"회의": []}, {"일반": []}],
      },
    },
    { timestamps: true }
  );
  return Room;
};

export default RoomModel;

