import Header from "../components/Header";
import { useState, useEffect } from "react";
import { useParams } from "react-router";
import roomApi from "../apis/room.api";
import userApi from "../apis/user.api";
import catchErrors from "../context/catchError";

const INIT_PROFILE = {
  id: "",
  roomNumber: "",
};

// userapi로 유저정보 불러다가, 참여방 목록에 그 방아이디 추가하고, 방에도 그 유저 아이디 추가한 다음에 참가시키기.
const InvitePage = () => {
  const [profile, setProfile] = useState([INIT_PROFILE]);
  const [error, setError] = useState("");
  const usercheck = sessionStorage.getItem("user");
  const { roomId } = useParams();

  async function getProfile(userID) {
    try {
      const data = await userApi.getUser(userID);
      setProfile(data);
    } catch (error) {
      catchErrors(error, setError);
    }
  }

  async function joinroom(userId, roomId) {
    try {
      // setLoading(true);
      setError("");
      const data = await roomApi.join({ userId: userId, roomId: roomId });
      console.log("서버연결됬나요", data);
    } catch (error) {
      catchErrors(error, setError);
    } finally {
      // setLoading(false);
    }
  }
  useEffect(() => {
    getProfile(usercheck);
  }, []);

  function goInvitedroom() {
    let check = null;
    if (usercheck === null) check = false;
    else check = true;

    if (check === true) {
      joinroom(usercheck, roomId);
      alert("방 참여가 완료되었습니다.");
      window.location.href=`/user/${usercheck}`
    } else {
      alert("로그인이 필요합니다.");
      window.location.href = `/`;
    }
  }

  function invitereject() {
    let check = null;
    if (usercheck === null) check = false;
    else check = true;

    if (check === true) {
      alert("유저 페이지로 이동합니다.");
      window.location.href = `/user/${usercheck}`;
    } else {
      alert("로그인이 필요합니다.");
      window.location.href = `/`;
    }
  }

  return (
    <div>
      {/*페이지 전체*/}
      <Header />
      <div className="d-flex justify-content-evenly">
        {/* 위 사진,이름 */}
        <div
        // style={{
        //   width: "100%",
        //   height: "140px",
        //   textAlign: "center",
        //   border: "3px",
        //   borderStyle: "none solid solid",
        //   borderColor: "red",
        //   fontSize: "12px",
        // }}
        >
          {/* 방 부분
          <p style={{ marginBottom: "0px", fontSize: "16px" }}>초대받은 방</p>
          <img style={{ width: "90px", height: "90px" }}></img>
          <p style={{ marginBottom: "0px", fontSize: "16px" }}>
            방 id: ${roomid}
          </p> */}
        </div>
      </div>

      <div
      // style={{
      //   width: "80%",
      //   height: "200px",
      //   textAlign: "center",
      //   fontSize: "18px",
      //   marginLeft: "10%",
      //   marginRight: "10%",
      // }}
      >
        {/* 아래 텍스트 */}
        <p
          align="center"
          style={{
            fontSize: "30px",
            marginTop: "120px",
            marginBottom: "80px",
          }}
        >
          축하합니다! 친구가 당신을
          <br />
          화상회의에 초대했습니다.
          <br />
          <br />
          <b>초대를 수락하시겠습니까?</b>
        </p>
      </div>

      <div className="d-flex justify-content-evenly">
        {/* 수락, 거절 버튼 */}
        {console.log(profile.roomNumber)}
        <button
          type="submit"
          className="col-2 p-1 btn btn-primary"
          data-bs-dismiss="modal"
          style={{ width: "120px" }}
          onClick={goInvitedroom}
        >
          수락
        </button>
        <button
          type="submit"
          className="col-2 p-1 btn btn-primary"
          data-bs-dismiss="modal"
          style={{ width: "120px" }}
          onClick={invitereject}
        >
          거절
        </button>
      </div>
    </div>
  );
};

export default InvitePage;
