import { Room, User } from "../models/index.js";
import { customAlphabet } from 'nanoid'
import isLength from 'validator/lib/isLength.js'

const nanoid = customAlphabet('1234567890abcdef', 10)

const joinRoom = async (req, res) => {
  const { userId, roomId } = req.body
  const room_Id = await Room.findOne({ where: { id: roomId } });
  if (Boolean(room_Id)) { //roomId에 일치하는 방이 존재할때
    //roomId에 일치하는 방의 member정보에 userId 저장하기
    //member정보에 userId가 이미 저장되어 있는지 확인 -> 이미 참여된 방인지 확인
    const includeUserId = room_Id.member.includes(parseInt(userId));
    // console.log('Include확인:',includeUserId) 
    if (!includeUserId) { //아직 참여되지 않은 방인경우
      room_Id.member.push(userId) //member에 userId추가
      // console.log('room_Id.member2:', room_Id.member)
      await Room.update({ 'member': room_Id.member }, { where: { id: roomId } })

      //userId에 일치하는 사용자의 roomNumber에 roomId저장하기
      const user_Id = await User.findOne({ where: { id: userId } });
      if (Boolean(user_Id.roomNumber)) { //다른 roomNumber가 이미 들어가 있는 경우 roomId추가
        user_Id.roomNumber.push(roomId)
      }
      else { //첫 roomNumber인 경우 
        user_Id.roomNumber = [roomId]
      }
      // console.log('user_Id.roomNumber2:', user_Id.roomNumber)
      await User.update({ 'roomNumber': user_Id.roomNumber }, { where: { id: userId } })
    } else {
      return res.status(422).send('이미 참여된 방입니다.')
    }
  } else {
    return res.status(422).send('참여코드와 일치하는 방이 존재하지 않습니다.')
  }
};

const createRoom = async (req, res) => {
  // console.log('룸정보', req.body)
  const { name, owner, member, profileimg } = req.body;
  const id = nanoid()
  const Id = await Room.findOne({ where: { id: id } });
  // console.log('id:', id)
  while (Boolean(Id)) {
    const id = nanoid()
    const Id = await Room.findOne({ where: { id: id } });
  }
  try {
    if (!isLength(name, { min: 3, max: 20 })) {
      return res.status(422).send('방이름은 3-20자여야 합니다.')
    }
    //새로운 RoomDB생성
    const newRoom = {
      id: id,
      name: name,
      owner: owner,
      member: [member],
      profileimg: profileimg,
    }
    // console.log('newRoom:', newRoom)
    await Room.create(newRoom)

    //user.roomNumber에 id추가
    const user_Id = await User.findOne({ where: { id: owner } });
    if (user_Id.roomNumber) { //다른 roomNumber가 이미 들어가 있는 경우 id추가
      user_Id.roomNumber.push(id)
    }
    else { //첫 roomNumber인 경우 
      user_Id.roomNumber = [id]
    }
    // console.log('user_Id.roomNumber2:', user_Id.roomNumber)
    await User.update({ 'roomNumber': user_Id.roomNumber }, { where: { id: owner } })
    res.json(newRoom)
  } catch (error) {
    console.log(error)
    res.status(500).send('방생성 에러')
  }
}

const getRoom = async (req, res) => {
  console.log('req.body:', req.body)
}

export default {
  joinRoom, createRoom, getRoom
};
