import axios from "axios";

const getUser = async (id) => {
  // console.log('id222:',id.userID)
  const { data } = await axios.get(`/api/getUser/${id}`);
  return data;
};

const login = async (payload) => {
  const { data } = await axios.post("/api/login", payload);
  return data;
};

const signup = async (payload) => {
  const { data } = await axios.post("/api/signup", payload);
  return data;
};

const updateinfo = async (payload) => {
  const { data } = await axios.put("/api/updateinfo", payload);
  return data;
};

const profileimg = async (formData) => {
  const { data } = await axios.put("/api/profileimg", formData);
  return data;
};

const userApi = { login, signup, getUser, profileimg, updateinfo };

export default userApi;
