import { Room } from "../models/index.js";
//import { customAlphabet } from 'nanoid'
import config from "../config/app.config.js";
import isLength from 'validator/lib/isLength.js'

//const nanoid = customAlphabet('1234567890abcdef', 10)

const roomJoin = async (req, res) => {
  try {
    console.log("login= ", req.body);
    res.json("안녕");
  } catch (error) {
    console.log(error);
    return res.status(500).send("안녕 중 에러");
  }
};

const roomCreate = async (req, res) => {
  const { name, owner, member, profileimg } = req.body;
  const id = nanoid()
  const Id = await Room.findOne({ id })
  while (Id) {
    id = nanoid()
    Id = await Room.findOne({ id })
  }

  try {
    if (!isLength(name, { min: 3, max: 20 })) {
      return res.status(422).send('방이름은 3-20자여야 합니다.')
    }

    const newRoom = await new Room({
      id,
      name,
      owner,
      member,
      profileimg,
    }).save()
    // console.log(newRoom)
    res.json(newRoom)
  } catch (error) {
    console.log(error)
    res.status(500).send('방생성 에러')
  }
}

export default {
  roomJoin, roomCreate
};
