import React, { useEffect, useState } from "react";
import { useParams } from "react-router";
import kakao_key from "../kakao.config.json";
import userApi from "../apis/user.api";
import catchErrors from "../context/catchError";

const INIT_invite = {
  id: "",
  name:"",
}

const KakaoShareButton = (porps) => {
  const [inviteperson, setProfile] = useState(INIT_invite);
  const [error,setError]=useState("");
  const { roomId } = useParams();
  const invitepersonId = localStorage.getItem("user");

  async function getProfile(userID) {
    try {
      const data = await userApi.getUser(userID);
      setProfile(data);
    } catch (error) {
      catchErrors(error, setError);
    }
  }

  useEffect(() => {
    getProfile(invitepersonId);
  }, []);

  useEffect(() => {
    createKakaoButton();
  }, []);

  useEffect(() => {
    const script = document.createElement('script')
    script.src = 'https://developers.kakao.com/sdk/js/kakao.js'
    script.async = true
    document.body.appendChild(script)
    return () => {
      document.body.removeChild(script)
    }
  }, [])

  const createKakaoButton = () => {
    // kakao sdk script이 정상적으로 불러와졌으면 window.Kakao로 접근이 가능합니다
    if (window.Kakao) {
      const kakao = window.Kakao;
      // 중복 initialization 방지
      if (!kakao.isInitialized()) {
        // 두번째 step 에서 가져온 javascript key 를 이용하여 initialize
        kakao.init(kakao_key[0].kakao_key);
      }
      kakao.Link.createDefaultButton({
        container: '#kakao-link-btn',
        objectType: 'text',
        text:
          `${inviteperson.name}님이 당신을 화상회의에 초대했습니다! 초대된 방 코드:${roomId}`,
          link: {
          mobileWebUrl:
            `http://localhost:3000/invite/${roomId}`,
          webUrl:
            `http://localhost:3000/invite/${roomId}`,
        },
      });
    }
  };
  
  return (
    <div className="kakao-share-button">
      {/* Kakao share button */}
      <button 
      id="kakao-link-btn"
      type="submit" 
      className="col-2 p-1 btn btn-primary"
      data-bs-dismiss="modal"
      style={{ width: "120px" }}
      >카카오로 초대
      </button>
    </div>
  );
};
export default KakaoShareButton;
