import axios from "axios";

const getRoom = async (id) => {
  const { data } = await axios.post('/api/room/getRoom', id);
  return data;
};

const exitRoom = async (ID) => {
  const { data } = await axios.delete(`/api/room/exitRoom/${ID.id}/${ID.roomId}`);
  return data;
};

const create = async (formData) => {
  const { data } = await axios.post("/api/room/create", formData);
  return data;
};

const join = async (payload) => {
  const { data } = await axios.put("/api/room/join", payload);
  return data;
};

const changename = async (payload) => {
  const { data } = await axios.put("/api/room/changename", payload)
  return data;
}

const profileimg = async (formData) => {
  const { data } = await axios.put("/api/room/profileimg", formData);
  return data;
};

const roomApi = { getRoom, exitRoom, create, join, changename, profileimg };

export default roomApi;
