// server 진입점
import dotenv from "dotenv";
import app from "./app.js";
import appConfig from "./config/app.config.js";
import { sequelize, User } from "./db/index.js";

dotenv.config({
  path: `${
    process.env.NODE_ENV === "production" ? ".env" : ".env.development"
  }`,
});

// production
// sequelize.sync().then(() => {
//   app.listen(appConfig.port, () => {
//     console.log(`Server is running on port ${appConfig.port}`)
//   })
// })

// development
// 주의!!!: {force: true}는 서버가 다시 시작되면 기존 디비 모두 삭제되고 새로운 디비 생성
sequelize
  .sync({ force: true })
  .then(async () => {
    // await Promise.all(
    //   Object.keys(ROLE_NAME).map((name) => {
    //     return Role.create({ name });
    //   })
    // );

    // const adminRole = await Role.findOne({ where: { name: "admin" } });

    await User.create({
      name: "admin",
      id: "admin",
      password: "admin!",
      idNumber: "0000",
    });

    app.listen(appConfig.port, () => {
      console.log(`Server is running on port ${appConfig.port}`);
    });
  })
  .catch((err) => {
    console.log(err);
  });
